/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.stealthp.rsslib;

import org.gnu.stealthp.rsslib.RSSChannel;
import org.gnu.stealthp.rsslib.RSSImage;
import org.gnu.stealthp.rsslib.RSSItem;
import org.gnu.stealthp.rsslib.RSSObject;
import org.gnu.stealthp.rsslib.RSSSequence;
import org.gnu.stealthp.rsslib.RSSSequenceElement;
import org.gnu.stealthp.rsslib.RSSSyndicationModule;
import org.gnu.stealthp.rsslib.RSSTextInput;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class RSSHandler
extends DefaultHandler {
    private StringBuffer buff = new StringBuffer();
    private String current_tag = null;
    private RSSChannel chan = new RSSChannel();
    private RSSItem itm;
    private RSSImage img;
    private RSSSequence seq;
    private RSSSequenceElement seq_elem;
    private RSSTextInput input;
    private RSSSyndicationModule sy;
    private boolean reading_chan = false;
    private boolean reading_item = false;
    private boolean reading_image = false;
    private boolean reading_seq = false;
    private boolean reading_input = false;
    private boolean have_dc = false;
    public static final String CHANNEL_TAG = "channel";
    public static final String TITLE_TAG = "title";
    public static final String LINK_TAG = "link";
    public static final String DESCRIPTION_TAG = "description";
    public static final String ITEM_TAG = "item";
    public static final String IMAGE_TAG = "image";
    public static final String IMAGE_W_TAG = "width";
    public static final String IMAGE_H_TAG = "height";
    public static final String URL_TAG = "url";
    public static final String SEQ_TAG = "rdf:seq";
    public static final String SEQ_ELEMENT_TAG = "rdf:li";
    public static final String TEXTINPUT_TAG = "textinput";
    public static final String NAME_TAG = "name";
    public static final String LANGUAGE_TAG = "language";
    public static final String MANAGING_TAG = "managingEditor";
    public static final String WMASTER_TAG = "webMaster";
    public static final String COPY_TAG = "copyright";
    public static final String PUB_DATE_TAG = "pubDate";
    public static final String LAST_B_DATE_TAG = "lastBuildDate";
    public static final String GENERATOR_TAG = "generator";
    public static final String DOCS_TAG = "docs";
    public static final String TTL_TAG = "ttl";
    public static final String AUTHOR_TAG = "author";
    public static final String COMMENTS_TAG = "comments";
    public static final String CLOUD_TAG = "cloud";
    public static final String RATING_TAG = "rating";
    public static final String SKIPH_TAG = "skipHours";
    public static final String SKIPD_TAG = "skipDays";
    public static final String CATEGORY_TAG = "category";
    public static final String DC_TITLE_TAG = "dc:title";
    public static final String DC_CREATOR_TAG = "dc:creator";
    public static final String DC_SUBJECT_TAG = "dc:subject";
    public static final String DC_DESCRIPTION_TAG = "dc:description";
    public static final String DC_PUBLISHER_TAG = "dc:publisher";
    public static final String DC_CONTRIBUTOR_TAG = "dc:contributor";
    public static final String DC_DATE_TAG = "dc:date";
    public static final String DC_TYPE_TAG = "dc:type";
    public static final String DC_FORMAT_TAG = "dc:format";
    public static final String DC_IDENTIFIER_TAG = "dc:identifier";
    public static final String DC_SOURCE_TAG = "dc:source";
    public static final String DC_LANGUAGE_TAG = "dc:language";
    public static final String DC_RELATION_TAG = "dc:relation";
    public static final String DC_COVERAGE_TAG = "dc:coverage";
    public static final String DC_RIGHTS_TAG = "dc:rights";
    public static final String SY_PERIOD_TAG = "sy:updatePeriod";
    public static final String SY_FREQ_TAG = "sy:updateFrequency";
    public static final String SY_BASE_TAG = "sy:updateBase";

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (RSSHandler.tagIsEqual(qName, CHANNEL_TAG)) {
            this.reading_chan = true;
            this.processChanAboutAttribute(attributes);
        }
        if (RSSHandler.tagIsEqual(qName, ITEM_TAG)) {
            this.reading_item = true;
            this.reading_chan = false;
            this.itm = new RSSItem();
            this.processItemAboutAttribute(attributes);
        }
        if (RSSHandler.tagIsEqual(qName, IMAGE_TAG)) {
            this.reading_image = true;
            this.reading_chan = false;
            this.img = new RSSImage();
        }
        if (RSSHandler.tagIsEqual(qName, SEQ_TAG)) {
            this.reading_seq = true;
            this.seq = new RSSSequence();
        }
        if (RSSHandler.tagIsEqual(qName, TEXTINPUT_TAG)) {
            this.reading_input = true;
            this.reading_chan = false;
            this.input = new RSSTextInput();
        }
        if (RSSHandler.tagIsEqual(qName, SEQ_ELEMENT_TAG)) {
            this.processSeqElement(attributes);
        }
        if (qName.toUpperCase().startsWith("SY:")) {
            this.sy = new RSSSyndicationModule();
        }
        this.current_tag = qName;
    }

    public void endElement(String uri, String localName, String qName) {
        String data = this.buff.toString().trim();
        if (qName.equals(this.current_tag)) {
            data = this.buff.toString().trim();
            this.buff = new StringBuffer();
        }
        if (this.reading_chan) {
            this.processChannel(qName, data);
        }
        if (this.reading_item) {
            this.processItem(qName, data);
        }
        if (this.reading_image) {
            this.processImage(qName, data);
        }
        if (this.reading_input) {
            this.processTextInput(qName, data);
        }
        if (RSSHandler.tagIsEqual(qName, CHANNEL_TAG)) {
            this.reading_chan = false;
            this.chan.setSyndicationModule(this.sy);
        }
        if (RSSHandler.tagIsEqual(qName, ITEM_TAG)) {
            this.reading_item = false;
            this.chan.addItem(this.itm);
        }
        if (RSSHandler.tagIsEqual(qName, IMAGE_TAG)) {
            this.reading_image = false;
            this.chan.setRSSImage(this.img);
        }
        if (RSSHandler.tagIsEqual(qName, SEQ_TAG)) {
            this.reading_seq = false;
            this.chan.addRSSSequence(this.seq);
        }
        if (RSSHandler.tagIsEqual(qName, TEXTINPUT_TAG)) {
            this.reading_input = false;
            this.chan.setRSSTextInput(this.input);
        }
    }

    public void characters(char[] ch, int start, int length) {
        String data = new String(ch, start, length);
        if (data.trim().length() == 0) {
            return;
        }
        this.buff.append(data);
    }

    private void processImage(String qName, String data) {
        if (RSSHandler.tagIsEqual(qName, TITLE_TAG)) {
            this.img.setTitle(data);
        }
        if (RSSHandler.tagIsEqual(qName, LINK_TAG)) {
            this.img.setLink(data);
        }
        if (RSSHandler.tagIsEqual(qName, URL_TAG)) {
            this.img.setUrl(data);
        }
        if (RSSHandler.tagIsEqual(qName, IMAGE_W_TAG)) {
            this.img.setWidth(data);
        }
        if (RSSHandler.tagIsEqual(qName, IMAGE_H_TAG)) {
            this.img.setHeight(data);
        }
        if (RSSHandler.tagIsEqual(qName, DESCRIPTION_TAG)) {
            this.img.setDescription(data);
        }
        if (qName.toUpperCase().startsWith("DC:")) {
            this.processDoublinCoreTags(qName, data, this.img);
        }
    }

    private void processTextInput(String qName, String data) {
        if (RSSHandler.tagIsEqual(qName, TITLE_TAG)) {
            this.input.setTitle(data);
        }
        if (RSSHandler.tagIsEqual(qName, LINK_TAG)) {
            this.input.setLink(data);
        }
        if (RSSHandler.tagIsEqual(qName, NAME_TAG)) {
            this.input.setInputName(data);
        }
        if (RSSHandler.tagIsEqual(qName, DESCRIPTION_TAG)) {
            this.input.setDescription(data);
        }
        if (qName.toUpperCase().startsWith("DC:")) {
            this.processDoublinCoreTags(qName, data, this.input);
        }
    }

    private void processItem(String qName, String data) {
        if (RSSHandler.tagIsEqual(qName, TITLE_TAG)) {
            this.itm.setTitle(data);
        }
        if (RSSHandler.tagIsEqual(qName, LINK_TAG)) {
            this.itm.setLink(data);
        }
        if (RSSHandler.tagIsEqual(qName, DESCRIPTION_TAG)) {
            this.itm.setDescription(data);
        }
        if (RSSHandler.tagIsEqual(qName, PUB_DATE_TAG)) {
            this.itm.setPubDate(data);
        }
        if (RSSHandler.tagIsEqual(qName, PUB_DATE_TAG)) {
            this.itm.setPubDate(data);
        }
        if (RSSHandler.tagIsEqual(qName, AUTHOR_TAG)) {
            this.itm.setAuthor(data);
        }
        if (RSSHandler.tagIsEqual(qName, COMMENTS_TAG)) {
            this.itm.setComments(data);
        }
        if (qName.toUpperCase().startsWith("DC:")) {
            this.processDoublinCoreTags(qName, data, this.itm);
        }
    }

    private void processChannel(String qName, String data) {
        if (RSSHandler.tagIsEqual(qName, TITLE_TAG)) {
            this.chan.setTitle(data);
        }
        if (RSSHandler.tagIsEqual(qName, LINK_TAG)) {
            this.chan.setLink(data);
        }
        if (RSSHandler.tagIsEqual(qName, DESCRIPTION_TAG)) {
            this.chan.setDescription(data);
        }
        if (RSSHandler.tagIsEqual(qName, COPY_TAG)) {
            this.chan.setCopyright(data);
        }
        if (RSSHandler.tagIsEqual(qName, PUB_DATE_TAG)) {
            this.chan.setPubDate(data);
        }
        if (RSSHandler.tagIsEqual(qName, LAST_B_DATE_TAG)) {
            this.chan.setLastBuildDate(data);
        }
        if (RSSHandler.tagIsEqual(qName, GENERATOR_TAG)) {
            this.chan.setGenerator(data);
        }
        if (RSSHandler.tagIsEqual(qName, DOCS_TAG)) {
            this.chan.setDocs(data);
        }
        if (RSSHandler.tagIsEqual(qName, TTL_TAG)) {
            this.chan.setTTL(data);
        }
        if (RSSHandler.tagIsEqual(qName, LANGUAGE_TAG)) {
            this.chan.setLanguage(data);
        }
        if (qName.toUpperCase().startsWith("DC:")) {
            this.processDoublinCoreTags(qName, data, this.chan);
        }
        if (qName.toUpperCase().startsWith("SY:")) {
            this.processSyndicationTags(qName, data);
        }
    }

    private void processDoublinCoreTags(String qName, String data, RSSObject o) {
        o.addDoublinCoreElement(qName.toLowerCase(), data);
    }

    private void processSyndicationTags(String qName, String data) {
        if (RSSHandler.tagIsEqual(qName, SY_BASE_TAG)) {
            this.sy.setSyUpdateBase(data);
        }
        if (RSSHandler.tagIsEqual(qName, SY_FREQ_TAG)) {
            this.sy.setSyUpdateFrequency(data);
        }
        if (RSSHandler.tagIsEqual(qName, SY_PERIOD_TAG)) {
            this.sy.setSyUpdatePeriod(data);
        }
    }

    private void processSeqElement(Attributes a) {
        String res = a.getValue(0);
        this.seq_elem = new RSSSequenceElement();
        this.seq_elem.setResource(res);
        this.seq.addElement(this.seq_elem);
    }

    private void processItemAboutAttribute(Attributes a) {
        String res = a.getValue(0);
        this.itm.setAboutAttribute(res);
    }

    private void processChanAboutAttribute(Attributes a) {
        String res = a.getValue(0);
        this.chan.setAboutAttribute(res);
    }

    private void processInputAboutAttribute(Attributes a) {
        String res = a.getValue(0);
        this.input.setAboutAttribute(res);
    }

    protected static boolean tagIsEqual(String a, String b) {
        return a.equalsIgnoreCase(b);
    }

    public RSSChannel getRSSChannel() {
        return this.chan;
    }
}

