/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.stealthp.rsslib;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.gnu.stealthp.rsslib.RSSException;
import org.gnu.stealthp.rsslib.RSSFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RSSParser {
    private SAXParserFactory factory = RSSFactory.getInstance();
    private DefaultHandler hnd;
    private File f;
    private URL u;
    private InputStream in;
    private boolean validate = false;

    public void setHandler(DefaultHandler h) {
        this.hnd = h;
    }

    public void setXmlResource(String file_name) throws RSSException {
        this.f = new File(file_name);
        try {
            this.in = new FileInputStream(this.f);
        }
        catch (Exception e) {
            throw new RSSException("RSSParser::setXmlResource fails: " + e.getMessage());
        }
    }

    public void setXmlResource(URL ur) throws RSSException {
        this.u = ur;
        Object ft = null;
        try {
            URLConnection con = this.u.openConnection();
            this.in = this.u.openStream();
            if (con.getContentLength() == -1) {
                this.fixZeroLength();
            }
        }
        catch (IOException e) {
            throw new RSSException("RSSParser::setXmlResource fails: " + e.getMessage());
        }
    }

    public void setValidate(boolean b) {
        this.validate = b;
    }

    public static void parseXmlFile(String filename, DefaultHandler handler, boolean validating) throws RSSException {
        RSSParser p = new RSSParser();
        p.setXmlResource(filename);
        p.setHandler(handler);
        p.setValidate(validating);
        p.parse();
    }

    public static void parseXmlFile(URL remote_url, DefaultHandler handler, boolean validating) throws RSSException {
        RSSParser p = new RSSParser();
        p.setXmlResource(remote_url);
        p.setHandler(handler);
        p.setValidate(validating);
        p.parse();
    }

    private void fixZeroLength() throws IOException, RSSException {
        File ft = File.createTempFile(".rsslib4jbugfix", ".tmp");
        ft.deleteOnExit();
        FileWriter fw = new FileWriter(ft);
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.in));
        BufferedWriter out = new BufferedWriter(fw);
        String line = "";
        while ((line = reader.readLine()) != null) {
            out.write(line + "\n");
        }
        out.flush();
        out.close();
        reader.close();
        fw.close();
        this.setXmlResource(ft.getAbsolutePath());
    }

    public void free() {
        this.factory = null;
        this.f = null;
        this.in = null;
        this.hnd = null;
        System.gc();
    }

    public void parse() throws RSSException {
        try {
            this.factory.setValidating(this.validate);
            this.factory.newSAXParser().parse(this.in, this.hnd);
        }
        catch (SAXException e) {
            throw new RSSException("RSSParser::parse fails: " + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new RSSException("RSSParser::parse fails: " + e.getMessage());
        }
        catch (IOException e) {
            throw new RSSException("RSSParser::parse fails: " + e.getMessage());
        }
    }
}

