/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.stealthp.rsslib;

import gnu.getopt.Getopt;
import java.net.URL;
import java.util.LinkedList;
import org.gnu.stealthp.rsslib.RSSChannel;
import org.gnu.stealthp.rsslib.RSSException;
import org.gnu.stealthp.rsslib.RSSHandler;
import org.gnu.stealthp.rsslib.RSSItem;
import org.gnu.stealthp.rsslib.RSSParser;
import org.xml.sax.helpers.DefaultHandler;

public class Test {
    public static void main(String[] args) {
        int c;
        if (args.length < 2) {
            Test.usage();
        }
        RSSHandler hand = new RSSHandler();
        Getopt opt = new Getopt("Test", args, "f:u:");
        while ((c = opt.getopt()) != -1) {
            switch (c) {
                case 102: {
                    String arg = opt.getOptarg();
                    try {
                        RSSParser.parseXmlFile(arg, (DefaultHandler)hand, false);
                    }
                    catch (RSSException e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                    break;
                }
                case 117: {
                    String arg = opt.getOptarg();
                    try {
                        URL u = new URL(arg);
                        RSSParser.parseXmlFile(u, (DefaultHandler)hand, false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                    break;
                }
                case 63: {
                    Test.usage();
                }
            }
        }
        RSSChannel ch = hand.getRSSChannel();
        System.out.println("****************CHANNEL INFO ************");
        System.out.println(ch.toString());
        if (ch.getRSSImage() != null) {
            System.out.println("IMAGE INFO: \n" + ch.getRSSImage().toString());
            System.out.println("IMAGE IN HTML: \n" + ch.getRSSImage().toHTML());
        } else {
            System.out.println("CHANNEL HAS NO IMAGE");
        }
        if (ch.getRSSTextInput() != null) {
            System.out.println("INPUT INFO: \n" + ch.getRSSTextInput().toString());
            System.out.println("HTML INPUT:\n" + ch.getRSSTextInput().toHTML());
        } else {
            System.out.println("CHANNEL HAS NO FORM INPUT");
        }
        if (ch.getDoublinCoreElements() != null) {
            System.out.println("DOUBLIN CORE INFO:");
            System.out.println(ch.getDoublinCoreElements().toString());
        } else {
            System.out.println("CHANNEL HAS NO DOUBLIN CORE TAGS");
        }
        System.out.println("SEQUENCE INFO:");
        if (ch.getItemsSequence() != null) {
            System.out.println(hand.getRSSChannel().getItemsSequence().toString());
        } else {
            System.out.println("CHANNELL HAS NO SEQUENCE MYBE VERSION 0.9 or 2?");
        }
        System.out.println("*****************************************");
        LinkedList lst = hand.getRSSChannel().getItems();
        System.out.println("****************ITEMS INFO *************");
        System.out.println("ITEM SIZE: " + lst.size());
        System.out.println("****************************************");
        for (int i = 0; i < lst.size(); ++i) {
            RSSItem itm = (RSSItem)lst.get(i);
            System.out.println("****************ITEM DETAILS *************");
            System.out.println(itm.toString());
            if (itm.getDoublinCoreElements() != null) {
                System.out.println("DOUBLIN CORE INFO FOR ITEM:");
                System.out.println(itm.getDoublinCoreElements().toString());
            } else {
                System.out.println("ITEM HAS NO DOUBLIN CORE TAGS");
            }
            System.out.println("******************************************");
        }
    }

    private static void usage() {
        String info = "Usage: java org.gnu.stealthp.rsslib.Test -f <local_file_name> | -u <remote_file_name>";
        System.out.println(info);
        System.exit(1);
    }
}

