/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.parse.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;

import org.apache.commons.digester.Digester;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

//import com.ponpo.portal.util.Environment;

/**
 * wlk\́B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class BaseDigester extends Digester {
	private File _WebAppRoot;
	public BaseDigester(XMLReader xmlReader,File webAppRoot) {
		
		super(xmlReader);
		_WebAppRoot=webAppRoot;
	}

	public InputSource resolveEntity(String publicId, String systemId)
		throws SAXException {
		InputSource inputSource = null;

		if (systemId != null) {
			URL url;
			try {
				url = new URL(systemId);
			} catch (MalformedURLException e1) {
				throw new SAXException(e1);
			}
			
			File dtdFile=new File(_WebAppRoot,url.getFile());
			FileInputStream fis;
			try {
				fis = new FileInputStream(dtdFile);
			} catch (FileNotFoundException e) {
				throw new SAXException(e);
			}
			if (fis != null) {
				InputStreamReader isr = new InputStreamReader(fis);
				inputSource = new InputSource(isr);
			}
		}

		return inputSource;
	}
}
