/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.parse.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.TreeSet;

import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public abstract class XMLParseBase implements ErrorHandler {
	public Object loadXMLData(File fileName,File dtdBase)throws SAXException, IOException{
		return loadXMLData(fileName.getPath(),dtdBase);
	}
	public Object loadXMLData(String fileName,File dtdBase)throws SAXException, IOException{
		FileInputStream pw = new FileInputStream(fileName);
		Object object=loadXMLData(pw,dtdBase);
		pw.close();
		return object;
	}
	public Object loadXMLData(InputStream inputStream,File dtdBase)throws SAXException{
		try {
			if (System.getProperty("org.xml.sax.driver") == null) {
				System.setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
			}

			XMLReader xmlReader = XMLReaderFactory.createXMLReader();
			xmlReader.setFeature("http://xml.org/sax/features/validation", true);

			BaseDigester digester = new BaseDigester(xmlReader,dtdBase);
			digester.setValidating(true);
			digester.push(this);
			setDetailRule(digester);
			digester.setErrorHandler(this);

			synchronized(digester){
				digester.parse(inputStream);
			}
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
		if(!_Errors.isEmpty()){
			throw new SAXException(_Errors.toString());
		}
		return getReturnData() ;

	}

	protected abstract void setDetailRule(BaseDigester digester);
	protected abstract Object getReturnData();
	Collection _Errors=new TreeSet();
	/* ( Javadoc)
	 * @see org.xml.sax.ErrorHandler#error(org.xml.sax.SAXParseException)
	 */
	public void error(SAXParseException exception) throws SAXException {
		setErrors(exception);
	}
	/* ( Javadoc)
	 * @see org.xml.sax.ErrorHandler#fatalError(org.xml.sax.SAXParseException)
	 */
	public void fatalError(SAXParseException exception) throws SAXException {
		setErrors(exception);
	}
	/* ( Javadoc)
	 * @see org.xml.sax.ErrorHandler#warning(org.xml.sax.SAXParseException)
	 */
	public void warning(SAXParseException exception) throws SAXException {
		setErrors(exception);
	}
	protected void setErrors(SAXParseException exception){
		StringBuffer sb=new StringBuffer();
		sb.append(exception.getLineNumber());
		sb.append("sځ@");
		sb.append(exception.getColumnNumber());
		sb.append("J@F");
		sb.append(exception.getMessage());
		_Errors.add(sb.toString());
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @return
	 */
	public Collection getErrorMessages() {
		return _Errors;
	}

}
