/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import javax.servlet.ServletConfig;

import com.ponpo.portal.util.Environment;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class ContextManager {
	private static Map  _Context=new HashMap();
	public static void init(ServletConfig config) throws PortalException{
		try {
			Class[] parmeterType=new Class[]{ServletConfig.class};
			InputStream propStream=Environment.getResourceAsStream("WEB-INF/config/implementer.properties");
			Properties	prop=new Properties();
			prop.load(propStream);
			Enumeration enum=prop.propertyNames();
			while (enum.hasMoreElements()) {
				String key=(String)enum.nextElement();
				String className=prop.getProperty(key);
				if (className == null || className.length() == 0) {
					;
				}else{
					Object object=null;
					try {
						Constructor constructor= Class.forName(className).getConstructor(parmeterType);
						object=constructor.newInstance(new Object[]{config});
					} catch (SecurityException e1) {
						throw new PortalException(e1);
					} catch (NoSuchMethodException e1) {
						try {
							object = Class.forName(className).newInstance();
						} catch (InstantiationException e) {
							throw new PortalException(e);
						} catch (IllegalAccessException e) {
							throw new PortalException(e);
						} catch (ClassNotFoundException e) {
							throw new PortalException(e);
						}
					} catch (ClassNotFoundException e1) {
						throw new PortalException(e1);
					} catch (IllegalArgumentException e1) {
						throw new PortalException(e1);
					} catch (InstantiationException e1) {
						throw new PortalException(e1);
					} catch (IllegalAccessException e1) {
						throw new PortalException(e1);
					} catch (InvocationTargetException e1) {
						throw new PortalException(e1.getTargetException());
					}
					_Context.put(key,object);
				}

			} 
		} catch (IOException e) {
			throw new PortalException(e);
		}
	}
	public static Object lookupImplementer(String id){
		return _Context.get(id);
	}
}
