/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ponpo.portal.util.Environment;
import com.ponpo.portal.util.RequestUtils;

/**
 * |[^T[ubgB<BR>
 * <PRE>
 * {VXe̐ǂT[ubgłB
 *  * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class PortalServlet extends HttpServlet {
	private static Log log = LogFactory.getLog(PortalServlet.class);
	public static String SERVLET_CONFIG=PortalServlet.class.getName()+".SERVLET_CONFIG";

	protected void doGet(HttpServletRequest req, HttpServletResponse res)
		throws ServletException, IOException {
			//GR[h̐ݒ
			try {
				req.setCharacterEncoding("utf-8");
			} catch (UnsupportedEncodingException e1) {
				;
			}

		if(log.isInfoEnabled()){
			log.info("=================================================");
			log.info("================= Start doGet ===================");
			log.info("=================================================");
		}

		if (req.getPathInfo() != null && req.getPathInfo().equals("/reload")) {
			log.info("Reload now!!");
			reload(getServletConfig());
			res.getWriter().println("OK Data reLoad now!!");
		} else {
			doProcess(req, res);
		}
		log.info("end doGet");
	}

	protected void doPost(HttpServletRequest req, HttpServletResponse res)
		throws ServletException, IOException {
			if(log.isInfoEnabled()){
				log.info("=================================================");
				log.info("================= Start doPost ===================");
				log.info("=================================================");
			}
		doProcess(req, res);
		log.info("end doPost");
	}
	/**
	 * 䏈B<BR>
	 * <PRE>
	 * {T[ubg̐s܂B
	 * </PRE>
	 * @param req
	 * @param res
	 * @throws ServletException
	 */
	private void doProcess(HttpServletRequest req, HttpServletResponse res)
		throws ServletException {
		log.info("start process");

		//GR[h̐ݒ
		try {
			req.setCharacterEncoding("utf-8");
		} catch (UnsupportedEncodingException e1) {
			;
		}
		//}`p[g̏
		if(FileUpload.isMultipartContent(req)){
			DiskFileUpload upload = new DiskFileUpload();
			try {
				RequestUtils.setMultiRequest(req,upload.parseRequest(req));
			} catch (FileUploadException e) {
				createServletException(req,res, e);
			}
		}
		if (log.isInfoEnabled()) {
			log.info("Request URL:"+RequestUtils.getCurrentUrlPath(req) );
			log.info("Remote Adress:"+req.getRemoteHost() );
			log.info("Header Info");
			for (Enumeration e = req.getHeaderNames(); e.hasMoreElements();) {
				String value = (String) e.nextElement();
				log.info(value + "=" + req.getHeader(value));
			}
			log.info("Parameter Info");
			for (Enumeration e = req.getParameterNames(); e.hasMoreElements();) {
				String value = (String) e.nextElement();
				log.info("  "+value + "=" + req.getParameter(value));
			}
		}
		
		try {
			//l̐ݒ
			req.setAttribute(SERVLET_CONFIG,getServletConfig());
			
			
			UserManager userManager=(UserManager)ContextManager.lookupImplementer("com.ponpo.portal.UserManager");
			String portalName=userManager.getStartPortal(req.getRemoteUser());

			PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
			PortletItem topItem=ViewPortal.createPortal(portletManager.getPortal(portalName),req,res);
			if(topItem==null){
				res.getWriter().println("<HTML><BODY><H1>you don't have MyPage</H1></BODY></HTML>");
				return;
			}
			

			
			PortalUtils.setURLPath(req.getContextPath()+req.getServletPath() ,topItem);
			PortletSystemDataUtils.setSelected(topItem,true);
			PortalUtils.setSelected(topItem,req.getPathInfo());	
				

			String redirectURL=null;
			if (RequestUtils.isExecuteAction(req)  ) {//ExecuteĂяoH
				PortletItem targetPortletItem=PortalUtils.lookupPortalItem(topItem, req.getPathInfo());
				if(targetPortletItem!=null){
					try{
						
						PortletAction portletAction=targetPortletItem.getActionInfo().getPortletAction();
						if(portletAction!=null){
							portletAction.doExecute(req, res,targetPortletItem);
							//ʑJ
							if (portletAction instanceof ForwardingURL) {
								ForwardingURL forwarding = (ForwardingURL) portletAction;
								redirectURL = forwarding.getFrowardURLWhenExec(req);
								if (redirectURL != null ) {
									if(ForwardingURL.ESC.equals(redirectURL)){
										redirectURL =res.encodeRedirectURL(RequestUtils.getCurrentUrlPath(req));
									}else{
										redirectURL =res.encodeRedirectURL(redirectURL);
									}
								}
							} else {
								redirectURL =res.encodeRedirectURL(RequestUtils.getCurrentUrlPath(req));
							}
						}
	
					} catch (ValidateError ve) {
						log.debug("catch validate Error");
						PortletSystemDataUtils.setErrorMsg(topItem,ve.getMsg());
					}catch(ForceForward e){
						PortletSystemDataUtils.setErrorMsg(topItem,e.getMessage());
						redirectURL=res.encodeRedirectURL(e.getForceURL());
					}
				}
			}

			if (redirectURL != null) {
				log.debug("sendRedirect Execute");
				res.sendRedirect(redirectURL);
			} else {
				PortletAction portletAction=topItem.getActionInfo().getPortletAction();
				if(portletAction!=null){
					try{
						String contents=portletAction.doView(req,res,topItem);
						res.getWriter().print(contents);
					}catch(ForceForward e){
						redirectURL=res.encodeRedirectURL(e.getForceURL());
						res.sendRedirect(redirectURL);
					}
				}
			}

			
		} catch (Throwable t) {
			createServletException(req,res, t);
		}

		log.info("end process");

	}

	private void createServletException(HttpServletRequest req, HttpServletResponse res,Throwable t) throws ServletException{
		if(t instanceof ServletException){
			Throwable cause=((ServletException)t).getRootCause();
			if(cause!=null){
				createServletException(req,res,cause);
				return;
			}
		}else if(t instanceof JspException){
			Throwable cause=((JspException)t).getRootCause();
			if(cause!=null){
				createServletException(req,res,cause);
				return;
			}
		}
		
		if(res.isCommitted()){
			req.setAttribute("THROWABLE",t);
			RequestDispatcher disptch =
				getServletContext().getRequestDispatcher("/error.jsp");

			try {
				log.fatal("Error is display",t);
				disptch.include(req,res);
			} catch (IOException e) {
				;
			}
		}else{
			log.fatal("Error is display",t);
			throw new ServletException(t);
		}
	}

	public void init(ServletConfig config) throws ServletException {
		super.init(config);
		log.info("Servlet init");


		try {
			reload(config);

		} catch (ServletException e) {
			log.error("",e.getRootCause());
			throw e;
		} catch (Exception e) {
			log.error("",e);
			throw new ServletException("",e);
		}
	}
	/**
	 * [hB<BR>
	 * <PRE>
	 * [h̏s܂B
	 * </PRE>
	 * @param config
	 * @throws ServletException
	 */
	private void reload(ServletConfig config) throws ServletException {
		
		try {
			loadConfig( config);
		} catch (PortalException e) {
			throw new ServletException(e.getCause());
		}
	}
	private void loadConfig(ServletConfig config) throws PortalException {
		Environment.setPortalRootPath(config.getServletContext().getRealPath("/"));
		ContextManager.init(config);
	}

}
