/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal;

import java.util.Collection;
import java.util.Iterator;

import com.ponpo.portal.util.StringUtils;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class PortalUtils {
	/**
	 * |[g[gACeB<BR>
	 * <PRE>
	 * ݑΏۂƂȂ|[g[gACe܂B
	 * </PRE>
	 * @param portletItem
	 * @return@ICAEgACe
	 */
	public static PortletItem lookupPortalItem(PortletItem portletItem,String pathInfo){
		String paths[]=StringUtils.separatPath(pathInfo);
		if(portletItem.getId().equals(paths[0]) ){
			Collection leafItems=portletItem.getLeaf();
			if(paths[1].length()>0){
				for (Iterator iterate = leafItems.iterator(); iterate.hasNext();) {
					PortletItem leafItem = (PortletItem) iterate.next();
					PortletItem rtn= lookupPortalItem(leafItem,paths[1]);
					if(rtn!=null){
						return rtn;
					}
				}
				if(leafItems.isEmpty()){
					String spAction=PortletSystemDataUtils.getSpecalActionName(portletItem);
					if(spAction!=null && spAction.equals(paths[1].substring(1))){
						return portletItem;
					}
				}
			}else{
				return portletItem;
			}
		}
		return null;
	}



	/**
	 * pXݒB<BR>
	 * <PRE>
	 * pXݒ肵܂B
	 * </PRE>
	 * @param basePath@x[XpX
	 * @param baseItem@CAEg
	 */
	public static void setURLPath(String basePath, PortletItem baseItem){
		String url=basePath+"/"+baseItem.getId();
		PortletSystemDataUtils.setURL(baseItem,url);
		for (Iterator iterate = baseItem.getLeaf().iterator(); iterate.hasNext();) {
			setURLPath(url,(PortletItem) iterate.next());
		}
	}

	public static void setSelected(PortletItem baseItem,String pathInfo){
		
		String paths[]=StringUtils.separatPath(pathInfo);
		String nextPath=paths[1];
		paths=StringUtils.separatPath(paths[1]);

		Collection leaf=baseItem.getLeaf();
		boolean findFlag=false;
		for (Iterator iterate = leaf.iterator(); iterate.hasNext();) {
			PortletItem portletItem = (PortletItem) iterate.next();
			if(portletItem.getId()!=null&&portletItem.getId().equals(paths[0])){
				findFlag=true;
				PortletSystemDataUtils.setSelected(portletItem,true);
				setSelected(portletItem ,nextPath);
			}else{
				PortletSystemDataUtils.setSelected(portletItem,false);
			}
			
		}
		if(!findFlag && !leaf.isEmpty() ){
			if(leaf.iterator().hasNext()){
				PortletItem portletItem =(PortletItem)leaf.iterator().next();
				PortletSystemDataUtils.setSelected(portletItem,true);
				setSelected(portletItem ,nextPath);
			}
		}
	}
	public  static void setOplations(PortletItem portletItem,String imageName,String url){
		PortletSystemDataUtils.setOplations(portletItem,imageName,url);
	}
	public static String getOperation( PortletItem entry){
		Collection oplCol=PortletSystemDataUtils.getOplations(entry);
		
		StringBuffer sb=new StringBuffer();
		for (Iterator iter = oplCol.iterator(); iter.hasNext();) {
			sb.append(iter.next());
		}
		return sb.toString();
	}


}
