/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal;

import java.util.Iterator;

/**
 * |[g[gACeB<BR>
 * <PRE>
 * |[g[gACẽC^[tF[XłB<BR>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public interface PortletDefine {
	/**
	 * ID擾B<BR>
	 * <PRE>
	 * ID̎擾s܂B
	 * </PRE>
	 * @return@O
	 */
	public String getPortletId();
	/**
	 * O擾B<BR>
	 * <PRE>
	 * O̎擾s܂B
	 * </PRE>
	 * @return@O
	 */
	public String getPortletName();
	public void setPortletName(String string);
	/**
	 * 擾B<BR>
	 * <PRE>
	 * ̎擾s܂B
	 * </PRE>
	 * @return@
	 */
	public String getRole();
	public void setRole(String string);
		/**
	 * ^擾B<BR>
	 * <PRE>
	 * ^̎擾s܂B
	 * </PRE>
	 * @param name
	 * @return@p[^[
	 */
	public String getMetaParam(String name);
	/**
	 * ^ꗗ擾B<BR>
	 * <PRE>
	 * ^ꗗ擾܂B
	 * </PRE>
	 * @return@^L[ꗗ
	 */
	public Iterator getMetaParamKeys();
	public void addMetaParam(String name, String value);
	public void removeMetaParam(String name);
	/**
	 * L[ꗗ擾B<BR>
	 * <PRE>
	 * L[ꗗ擾܂B
	 * </PRE>
	 * @return@L[ꗗ
	 */
	public ActionInfo getAction(String Name);
	public ActionInfo newAction(String type);
	public void addAction(ActionInfo actionInfo);
	public void removeAction(ActionInfo actionInfo);
	/**
	 * L[ꗗ擾B<BR>
	 * <PRE>
	 * L[ꗗ擾܂B
	 * </PRE>
	 * @return@L[ꗗ
	 */
	public Iterator getActionKeys();

	/**
	 * p[^[擾B<BR>
	 * <PRE>
	 * p[^[̎擾s܂B
	 * </PRE>
	 * @param key
	 * @return@p[^[
	 */
	public PortletParam getPortletParam(String key);
	public PortletParam newPortletParam();
	public void addPortletParam(PortletParam portletParam);
	public void removePortletParam(PortletParam portletParam);
	/**
	 * L[ꗗ擾B<BR>
	 * <PRE>
	 * L[ꗗ擾܂B
	 * </PRE>
	 * @return@L[ꗗ
	 */
	public Iterator getPortletParamKeys();
}
