/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal;

import java.util.Collection;
import java.util.Iterator;

/**
 * |[g[gACeB<BR>
 * <PRE>
 * |[g[gACẽC^[tF[XłB<BR>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public interface PortletItem  {
	/**
	 * hc擾B<BR>
	 * <PRE>
	 * hc擾܂B<BR>
	 * </PRE>
	 * @return ŗLl
	 */
	public String getId();
	public void setId(String string);
	/**
	 * x擾B<BR>
	 * <PRE>
	 * x擾܂B
	 * </PRE>
	 * @return@x
	 */
	public String getLabel();
	public void setLabel(String string);
	/**
	 * }擾B<BR>
	 * <PRE>
	 * ̃CAEg̎}擾܂B
	 * </PRE>
	 * @return@}
	 */
	public Collection /* PortletItem */	getLeaf();
	/**
	 * }ݒB<BR>
	 * <PRE>
	 * ̃CAEg̎}ݒ肵܂B
	 * </PRE>
	 * @param@leaf@}
	 */
	public void setLeaf(Collection /* PortletItem */ leaf);

	/**
	 * 擾B<BR>
	 * <PRE>
	 * 擾܂B<BR>
	 * </PRE>
	 * @return@
	 */
	public String getReadRole();
	public void setReadRole(String string);
	/**
	 * 擾B<BR>
	 * <PRE>
	 * 擾܂B<BR>
	 * </PRE>
	 * @return@
	 */
	public String getEditRole();
	public void setEditRole(String string);
	
	public ActionInfo getActionInfo();
	public void setActionInfo(ActionInfo actionInfo);
	/**
	 * ^уf[^擾B<BR>
	 * <PRE>
	 * ^уf[^擾܂
	 * </PRE>
	 * @param key@L[
	 * @return@f[^
	 */
	public Object getSystemData(String key);
	public Object getParamData(String key);
	public String getStrParam(String key);
	/**
	 * ^уf[^ݒB<BR>
	 * <PRE>
	 * ^уf[^ݒ肵܂
	 * </PRE>
	 * @param key@L[
	 * @return@f[^
	 */
	public void addSystemData(String key,Object data);
	public Iterator getSystemDataKeys();
	/**
	 * N[쐬<BR>
	 * <PRE>
	 * ̃N[쐬܂
	 * </PRE>
	 * @return@N[l
	 */
	public PortletItem cloneItem() ;

	/**
	 * gp|[gbg̖O擾B<BR>
	 * <PRE>
	 * gp|[gbg̖O̎擾s܂B
	 * </PRE>
	 * @return@gp|[gbg̖O
	 */
	public String getPortletName();
	public void setPortletName(String string);

	/**
	 * p[^[擾B<BR>
	 * <PRE>
	 * p[^[̎擾s܂B
	 * </PRE>
	 * @param key
	 * @return@p[^[
	 */
	public String getPortletParam(String key);
	/**
	 * L[ꗗ擾B<BR>
	 * <PRE>
	 * L[ꗗ擾܂B
	 * </PRE>
	 * @return@L[ꗗ
	 */
	public Iterator getPortletParamKeys();
	/**
	 * p[^[ݒB<BR>
	 * <PRE>
	 * p[^[̐ݒs܂B
	 * </PRE>
	 * @param name
	 * @param value
	 */
	public void addPortletParam(String name, String value);
	public void removePortletParam(String name);
}
