/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal;

import java.util.Iterator;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public interface PortletManager {

	public PortletItem getPortal(String portalName) throws PortalException;
	public Iterator getPortalKeys();
	public void removePortal(String portalName) throws PortalException;
	public void copyPortal(String fromPortal,String  toPotal) throws PortalException;
	public void savePortal(String portalName) throws PortalException;
	public PortletItem newPortletItem();


	public PortletDefine newPortletDefine(String portletId);
	public PortletDefine getPortletDefine(String portletId);
	public void setPortletDefine(PortletDefine portletDefine);
	public Iterator getPortletDefinesKeys();
	public void removePortletDefine(PortletDefine portletDefine);
	public void savePortletDefine() throws PortalException;

	public PortletStyle getPortletStyle(String portalStyleId) throws PortalException;
	public PortletStyle newPortletStyle(String portalStyleId) throws PortalException;
	public Iterator getPortletStyleKeys() throws PortalException;
	public void removePortletStyle(PortletStyle portletStyle);
	public void setPortletStyle(PortletStyle portletStyle) throws PortalException;
	public void savePortletStyle() throws PortalException;
}
