/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class PortletSystemDataUtils {
	private static String MESSAGE="MESSAGE";
	private static String PORTLET_URL="PORTLET_URL";
	private static String PORTLET_SP_ACTION_NAME="PORTLET_SP_ACTION_NAME";
	private static String PORTLET_SELECTED="PORTLET_SELECTED";
	private static String PORTLET_OPLATIONS="PORTLET_OPLATIONS";
	public static void setURL(PortletItem portletItem,String url){
		portletItem.addSystemData(PORTLET_URL,url);
	}
	public static String getURL(PortletItem portletItem){
		return (String)portletItem.getSystemData(PORTLET_URL);
	}
	public static void setSelected(PortletItem portletItem,boolean selected){
		portletItem.addSystemData(PORTLET_SELECTED,new Boolean(selected));
	}
	public static boolean getSelected(PortletItem portletItem){
		Boolean bool=(Boolean)portletItem.getSystemData(PORTLET_SELECTED);
		if(bool!=null){
			return bool.booleanValue();
		}
		return false;
	}
	public static void setSpecalActionName(PortletItem portletItem,String url){
		portletItem.addSystemData(PORTLET_SP_ACTION_NAME,url);
	}
	public static String getSpecalActionName(PortletItem portletItem){
		return (String)portletItem.getSystemData(PORTLET_SP_ACTION_NAME);
	}
	public static void setErrorMsg(PortletItem portletItem,String msg){
		Collection errCollection=new ArrayList();
		errCollection.add(msg);
		setErrorMsg(portletItem,errCollection);
	}
	public static void setErrorMsg(PortletItem portletItem,Collection msg){
		if(msg==null){
			portletItem.addSystemData(MESSAGE,null);
			return;
		}
		Collection errCollection=(Collection)portletItem.getSystemData(MESSAGE);
		if(errCollection==null){
			errCollection=new ArrayList();
			portletItem.addSystemData(MESSAGE,errCollection);
		}
		errCollection.addAll(msg);
	}
	public static Collection getErrorMsg(PortletItem portletItem){
		return (Collection)portletItem.getSystemData(MESSAGE);
	}
	public  static void setOplations(PortletItem portletItem,String imageName,String url){
		Collection oplCollection=(Collection)portletItem.getSystemData(PORTLET_OPLATIONS);
		if(oplCollection==null){
			oplCollection=new ArrayList();
			portletItem.addSystemData(PORTLET_OPLATIONS,oplCollection);
		}
		oplCollection.add(new ImageValueData(imageName,url));
	}
	public static Collection getOplations(PortletItem portletItem){
		Collection col= (Collection)portletItem.getSystemData(PORTLET_OPLATIONS);
		Collection rtn=new ArrayList();
		if(col!=null){
			for (Iterator iter = col.iterator(); iter.hasNext();) {
				ImageValueData element = (ImageValueData) iter.next();
				rtn.add(element.getUrlString());
			}
		}
		return rtn;
	}
}
class ImageValueData{
	String _ImageName;
	String _Url;
	public ImageValueData(){
	}
	public ImageValueData(String imageName,String url){
		_ImageName=imageName;
		_Url=url;
	}
	public String getUrlString(){
		StringBuffer sb=new StringBuffer();
		sb.append("<a href=\"");
		sb.append(_Url);
		sb.append("\">");
		sb.append("<img border=\"0\" src=\"");
		sb.append(_ImageName);
		sb.append("\">");
		sb.append("</a>");
		return sb.toString();
	}
}
