/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ponpo.portal.util.StringUtils;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class ViewPortal {
	private static String[] KEY_WORD=new String[]{"portlet_edit"};
	/**
	 * \|[^쐬B<BR>
	 * <PRE>
	 * \ׂ̃|[^쐬B<BR>
	 * </PRE>
	 * @param portletItem@CAEg
	 * @param req@NGXg
	 * @param res@X|X
	 * @return@\|[^
	 */
	public static PortletItem createPortal(PortletItem portletItem,HttpServletRequest req,HttpServletResponse res) {
		if(portletItem==null){
			return null;
		}
		ParamInfo paramInfo=new ParamInfo();
		paramInfo._SecurityManager=(SecurityManager)ContextManager.lookupImplementer("com.ponpo.portal.SecurityManager");
		paramInfo._PortletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
		paramInfo._Request=req;
		paramInfo._Response=res;

		PortletItem newPortletItem;

		String pathInfo=req.getPathInfo();

		String paths[]=StringUtils.separatPath(pathInfo);
		newPortletItem=createPortletBody(paramInfo,portletItem);
		if(newPortletItem!=null){
			doSpcalAction(paramInfo,newPortletItem,paths[1]);	
			newPortletItem.setLeaf(createPortalLeaf(paramInfo,newPortletItem.getLeaf(),paths[1]));
		}
		return newPortletItem;
	}

	/**
	 * \CAEg쐬B<BR>
	 * <PRE>
	 * \邽߂̃CAEg쐬܂B
	 * </PRE>
	 * @param portletItems@CAEgACe@
	 * @param portletLeafItems ZLeB[}lW[
	 * @param pathInfo@pX
	 * @return@\CAEg
	 */
	private static Collection createPortalLeaf(ParamInfo paramInfo,Collection portletLeafItems,String pathInfo){
		String paths[]=StringUtils.separatPath(pathInfo);
		boolean selected=false;
		Collection rtnItem=new ArrayList();

		for (Iterator iterate = portletLeafItems.iterator(); iterate.hasNext();) {
			PortletItem leafItem = (PortletItem) iterate.next();
			leafItem =createPortletBody(paramInfo,leafItem);
			if(leafItem!=null){
				rtnItem.add(leafItem);
				if(leafItem.getId()!=null && leafItem.getId().equals(paths[0])){		
					selected=true;
					doSpcalAction(paramInfo,leafItem,paths[1]);
					leafItem.setLeaf( createPortalLeaf(paramInfo,leafItem.getLeaf(),paths[1]));
				}
			}
		}

		if(!selected){
			if(!rtnItem.isEmpty() ){
				if(rtnItem.iterator().hasNext()){
					PortletItem portletItem =(PortletItem)rtnItem.iterator().next();
					doSpcalAction(paramInfo,portletItem,paths[1]);
					portletItem.setLeaf( createPortalLeaf(paramInfo,portletItem.getLeaf(),paths[1]));
				}
			}
		}
		return rtnItem;
	}
	private static PortletItem createPortletBody(ParamInfo paramInfo,PortletItem orginalPortletItem){
		PortletItem portletItem =orginalPortletItem .cloneItem();
		PortletDefine defineItem=paramInfo._PortletManager.getPortletDefine(portletItem.getPortletName());
		if(defineItem==null){
			defineItem=paramInfo._PortletManager.getPortletDefine("notFindPortlet");
			portletItem.addSystemData("portletName",portletItem.getPortletName());
			
		}else{
			if(!paramInfo._SecurityManager.isEnabled(paramInfo._Request,paramInfo._Response,defineItem.getRole())){
				return null;
			}
		}
		ActionInfo actionInfo=null;
		if(defineItem!=null){
			actionInfo=defineItem.getAction(null);
		}
		if(actionInfo==null){
			defineItem=paramInfo._PortletManager.getPortletDefine("nowPlanning");
			portletItem.addSystemData("portletName",portletItem.getPortletName());
			if(defineItem!=null){
				actionInfo=defineItem.getAction(null);
			}
		}
		if(actionInfo!=null){
			for(Iterator iter=actionInfo.getParamKeys();iter.hasNext();){
				String key=(String)iter.next();
				portletItem.addSystemData(key,actionInfo.getParam(key));
			}
		}
		portletItem.setActionInfo(actionInfo);
		return portletItem;
	}

	private static void doSpcalAction(ParamInfo paramInfo,PortletItem portletItem,String chiledPath){

		if(chiledPath!=null && chiledPath.length()>0){
			PortletDefine defineItem=paramInfo._PortletManager.getPortletDefine(portletItem.getPortletName());
			String action=chiledPath.substring(1);
			ActionInfo actionInfo=null;

			if(defineItem!=null){
				actionInfo=defineItem.getAction(action);
			}

			if(actionInfo==null){
				for (int cnt = 0; cnt < KEY_WORD.length; cnt++) {
					if(action.equals(KEY_WORD[cnt])){
						if(paramInfo._SecurityManager.isEditEnabled(
							paramInfo._Request,
							paramInfo._Response,
							portletItem)){
							String actionName=KEY_WORD[cnt];
							defineItem=paramInfo._PortletManager.getPortletDefine(actionName);
							actionInfo=defineItem.getAction(null);
						}
						break;
					}
				}
			}
			if(actionInfo!=null){
				portletItem.setActionInfo(actionInfo);
				PortletSystemDataUtils.setSpecalActionName(portletItem,action);
				portletItem.setLeaf(new ArrayList());

				if(actionInfo!=null){
					for(Iterator iter=actionInfo.getParamKeys();iter.hasNext();){
						String key=(String)iter.next();
						portletItem.addSystemData(key,actionInfo.getParam(key));
					}
				}

				return ;
			}
		}
	}
}
class ParamInfo{
	public ParamInfo(){
	}
	HttpServletRequest _Request;
	HttpServletResponse _Response;
	PortletManager _PortletManager;
	SecurityManager _SecurityManager;
}
