/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.action;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ponpo.portal.ActionInfo;
import com.ponpo.portal.ContextManager;
import com.ponpo.portal.ForceForward;
import com.ponpo.portal.ForwardingURL;
import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortletAction;
import com.ponpo.portal.PortletItem;
import com.ponpo.portal.PortletManager;
import com.ponpo.portal.PortletStyle;
import com.ponpo.portal.PortletStyleAction;
import com.ponpo.portal.PortletSystemDataUtils;
import com.ponpo.portal.ValidateError;
import com.ponpo.portal.util.RequestUtils;
import com.ponpo.taglib.DataManager;



/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
abstract public class BasePortletAction implements PortletAction {
	private static Log log = LogFactory.getLog(BasePortletAction.class);
	private static String REQ_KEY = BasePortletAction.class.getName()+".REQ_KEY";


	/* ( Javadoc)
	 * @see com.ponpo.portal.action.PortletAction#createDisplayData(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	public String doView(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {

		if (RequestUtils.isActName(req, "esc")) {
			try {
				res.sendRedirect(
					res.encodeRedirectURL(
						RequestUtils.getCurrentUrlPath(req)));
			} catch (IOException e) {
				throw new PortalException(e);
			}
			return "";
		}
		String contents;
		try{
			Object reqData=req.getAttribute(REQ_KEY);
			Object my=req.getAttribute(REQ_KEY);
			if(reqData!=null){
				Map map=(Map)reqData;
				my=map.get(PortletSystemDataUtils.getURL(entry));
			}else{
				my=null;
			}


			if(my==null){
				makeDisplayDate(req,res,entry);
				my=this;
			}

			DataManager.setData(req,my);
			String spName=PortletSystemDataUtils.getSpecalActionName(entry);
			if(spName==null){
				DataManager.setRequestURL(req,PortletSystemDataUtils.getURL(entry));
			}else{
				DataManager.setRequestURL(req,PortletSystemDataUtils.getURL(entry)+"/"+spName);
			}
			JspCoreAction jspAction =new JspCoreAction();
			contents=jspAction.doView(req,res,entry);

		}catch(PortalException e){
			contents=getExceptionFormat("portletName="+entry.getPortletName(),e.getCause() );
		}catch(ForceForward e){
			throw e;
		}catch(Throwable e){
			contents=getExceptionFormat("portletName="+entry.getPortletName(),e );
		}
		
		String styleName="";
		try{
			styleName=entry.getPortletParam("style");
			if(styleName==null){
				ActionInfo actionInfo=entry.getActionInfo();
				styleName=actionInfo.getParam("style");
			}
			if(styleName!=null){
				PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
				PortletStyle portletStle=portletManager.getPortletStyle(styleName);
				if(portletStle!=null){
					PortletStyleAction action=portletStle.getSytleAction();
					return action.doView(req,res,entry,portletStle,contents);
				}
			}
		}catch(PortalException e){
			contents=getExceptionFormat("styleName="+styleName,e.getCause() );
		}
		return contents;
			
	}
	private String getExceptionFormat(String Message,Throwable t){
		log.fatal(Message,t );
		StringBuffer sb=new StringBuffer();
		StringWriter sw=new StringWriter();
		t.printStackTrace(new PrintWriter(sw));
		sb.append("<div class=\"message\">");
		sb.append("<h3>Exception </h3>");
		sb.append("Message:");
		sb.append(Message);
		sb.append("<pre>");
		sb.append(sw.toString());
		sb.append("</pre>");
		sb.append("</div>");
		return sb.toString();

	}
	/* ( Javadoc)
	 * @see com.ponpo.portal.action.PortletAction#doExecute(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	public void doExecute(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		if (RequestUtils.isActName(req, "esc")) {
			try {
				res.sendRedirect(
					res.encodeRedirectURL(
						RequestUtils.getCurrentUrlPath(req)));
			} catch (IOException e) {
				throw new PortalException(e);
			}
			return ;
		}
		try{
			initExec(req,res,entry);
			validate(req,res,entry);
			doLogic(req,res,entry);
			if(this instanceof ForwardingURL){
				ForwardingURL forwardingURL=(ForwardingURL)this;
				if(forwardingURL.getFrowardURLWhenExec(req)==null){
					setRedirectData(req,entry);
				}
			}
		}catch(ValidateError ve){
			setRedirectData(req,entry);
			throw ve;
		}
		return ;
	}
	private void setRedirectData(HttpServletRequest req,PortletItem entry){
		Object reqData=req.getAttribute(REQ_KEY);
		Map map;
		if(reqData!=null){
			map=(Map)reqData;
		}else{
			map=new HashMap();
		}
		map.put(PortletSystemDataUtils.getURL(entry),this);
		req.setAttribute(REQ_KEY,map);
		
	}
	abstract protected void  makeDisplayDate(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException,ValidateError;
	abstract protected void  initExec(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException,ValidateError;
	
	/**
	 * ̓`FbNB<BR>
	 * <PRE>
	 * ͂lÓ𔻒肷B
	 * ÓoȂValidateErrorɒlԂB
	 * </PRE>
	 * @throws PortalException O
	 * @throws ValidateError@͕s
	 */
	abstract protected void  validate(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException,ValidateError;

	/**
	 * _B<BR>
	 * <PRE>
	 * _Lq܂B
	 * ɂł́AcaANZX̏Lq܂B
	 * ̓`FbN̂݌Ă΂܂B
	 * </PRE>
	 * @throws PortalException O
	 */
	abstract protected void  doLogic(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException;
}
