/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.action;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ponpo.portal.ForceForward;
import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortletItem;
import com.ponpo.portal.PortletSystemDataUtils;
import com.ponpo.portal.ValidateError;
import com.ponpo.portal.util.RequestUtils;


/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class EventPortletAction extends BasePortletAction {
	private static Log log = LogFactory.getLog(EventPortletAction.class);


	protected ValidateError _ValidateError = new ValidateError();
	/* ( Javadoc)
	 * @see com.ponpo.portal.action.BasePortletAction#validate(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	protected void validate(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		dispatchMethodWithDefault(req,res,entry,"validate",RequestUtils.getActionName(req));
		if (!_ValidateError.getMsg().isEmpty()) {
			throw _ValidateError;
		}

	}

	/* ( Javadoc)
	 * @see com.ponpo.portal.action.BasePortletAction#logic(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	protected void doLogic(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		dispatchMethodWithDefault(req,res,entry,"logic",RequestUtils.getActionName(req));
		if (!_ValidateError.getMsg().isEmpty()) {
			throw _ValidateError;
		}
	}

	/* ( Javadoc)
	 * @see com.ponpo.portal.action.PortletAction#createDisplayData(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	public void makeDisplayDate(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		String url=RequestUtils.getCurrentUrlPath(req);
		String spName=PortletSystemDataUtils.getSpecalActionName(entry);
		if(spName!=null){
			url=url.substring(0,url.length()-spName.length()-1);
		}
		if(url.equals(PortletSystemDataUtils.getURL(entry))){
			dispatchMethodWithDefault(req,res,entry,"displayInit",RequestUtils.getActionName(req));
		}else{
			dispatchMethodWithDefault(req,res,entry,"displayInit",null);
		}
	}
	protected void dispatchMethodWithDefault(HttpServletRequest req, HttpServletResponse res, PortletItem entry,String name,String subName) throws PortalException{
		if(subName==null){
			dispatchMethod(req,res,entry,name+"Default");
		}else if(!dispatchMethod(req,res,entry,name,subName)){
			dispatchMethod(req,res,entry,name+"Default");
		}
	}
	protected boolean dispatchMethod(HttpServletRequest req, HttpServletResponse res, PortletItem entry,String name,String subName) throws PortalException{
		String  action=subName.toLowerCase();
		if(action.length()>0){
			action=action.substring(0,1).toUpperCase()+action.substring(1).toLowerCase();
		}
		return dispatchMethod(req,res,entry,name+action);
	}
	protected boolean dispatchMethod(HttpServletRequest req, HttpServletResponse res, PortletItem entry,String name) throws PortalException{

		if(log.isDebugEnabled()){
			log.debug("Call Event:"+name);
		}
		Class[] callType=new Class[]{HttpServletRequest.class,HttpServletResponse.class,PortletItem.class};
		try {
			Method method = null;
			method =this.getClass().getMethod(name, callType); 
			method.invoke(this,new Object[]{req,res,entry});
		} catch (NoSuchMethodException e) {
			log.debug("NoSuchMethod:"+e.getMessage());
			return false;
		} catch (InvocationTargetException e) {
			Throwable targetException=e.getTargetException();
			if(targetException instanceof PortalException){
				throw (PortalException)targetException;
			}
			if(targetException instanceof ForceForward){
				throw (ForceForward)targetException;
			}
			throw new PortalException(targetException);
		} catch (Exception e) {
			throw new PortalException(e);
		}
		return true;
	}

	/* ( Javadoc)
	 * @see com.ponpo.portal.action.BasePortletAction#initExec(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	protected void initExec(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException, ValidateError {
		dispatchMethodWithDefault(req,res,entry,"displayExec",RequestUtils.getActionName(req));
		if (!_ValidateError.getMsg().isEmpty()) {
			throw _ValidateError;
		}
	}
}
