/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.action;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ponpo.portal.ActionInfo;
import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortletAction;
import com.ponpo.portal.PortletItem;
import com.ponpo.portal.ValidateError;
import com.ponpo.portal.util.JspLoader;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class JspCoreAction implements PortletAction {
	/* ( Javadoc)
	 * @see com.ponpo.portal.action.PortletAction#createDisplayData(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	public String doView(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		ActionInfo actionInfo=entry.getActionInfo();
		String jspFile =actionInfo.getParam("jsp");
		if(jspFile!=null){
			JspLoader jsp=new JspLoader();
			try{
				return jsp.doView(req,res,jspFile);
			} catch (ServletException e) {
				throw new PortalException(e);
			} catch (IOException e) {
				throw new PortalException(e);
			}
		}
		return "";
	}

	/* ( Javadoc)
	 * @see com.ponpo.portal.action.PortletAction#doExecute(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	public void doExecute(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException, ValidateError {
		return ;
	}
	
}
