/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortletItem;
import com.ponpo.taglib.IterateData;
import com.ponpo.taglib.PlainData;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class ParamMultiAction extends EventPortletAction implements PlainData,IterateData{

	private PortletItem _Entry;
	/* ( Javadoc)
	 * @see com.ponpo.portal.PortletAction#setData(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	public void displayInitDefault(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		_Entry=entry;
	}

	/* ( Javadoc)
	 * @see com.ponpo.taglib.PlainData#getTagData(java.lang.String)
	 */
	public String getTagData(HttpServletRequest req,String key) {
		String value=_Entry.getStrParam(key);
		return value;
	}

	/* ( Javadoc)
	 * @see com.ponpo.taglib.IterateData#getIterator(javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public Object getIterator(HttpServletRequest req, String reqKey) throws JspException {
		Collection col=new ArrayList();
		for (Iterator iter = _Entry.getPortletParamKeys(); iter.hasNext();) {
			String key = (String) iter.next();
			if(!key.equals("style")){
				Map map=new HashMap();
				col.add(map);
				map.put("name",key);
				map.put("value",_Entry.getPortletParam(key));
			}
		}
		return col;
	}


}
