/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.cgi.perl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

import com.ponpo.portal.ForceForward;
import com.ponpo.portal.ForwardingURL;
import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortalServlet;
import com.ponpo.portal.PortletAction;
import com.ponpo.portal.PortletItem;
import com.ponpo.portal.PortletSystemDataUtils;
import com.ponpo.portal.ValidateError;
import com.ponpo.portal.util.RequestUtils;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class PortletBridgesCGI implements PortletAction,ForwardingURL{

	/* ( Javadoc)
	 * @see com.ponpo.portal.PortletAction#doView(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	public String doView(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		String portletUrl=PortletSystemDataUtils.getURL(entry)+"/";
		String reqUrl=RequestUtils.getCurrentUrlPath(req);
		if(!reqUrl.startsWith(portletUrl)){
			throw new ForceForward(portletUrl,"null");
		}
		ActionResponseWrapper myRes= new ActionResponseWrapper(res);
		
		CGIAction action=new CGIAction();
		try {
			action.init((ServletConfig)req.getAttribute(PortalServlet.SERVLET_CONFIG),entry);
			String dir=entry.getStrParam("dir");
			String cgi=entry.getStrParam("cgi");
			String addParam=entry.getStrParam("addParam");
			HttpServletRequest myReq=new CgiRequest(req,portletUrl,dir,cgi,addParam);
			action.doGet(myReq,myRes);
		} catch (ServletException e1) {
			throw new PortalException(e1);
		} catch (IOException e) {
			throw new PortalException(e);
		}

		return myRes.toString();
	}




	/* ( Javadoc)
	 * @see com.ponpo.portal.PortletAction#doExecute(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	public void doExecute(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException, ValidateError {
	}
	class ActionResponseWrapper extends HttpServletResponseWrapper {

		private ByteArrayOutputStream _Buffer=new ByteArrayOutputStream();

		private PrintWriter _PrintWriter;
		private String _Redirect_Location= null;

		public ActionResponseWrapper(ServletResponse response) {

			super((HttpServletResponse)response);
			_PrintWriter= new PrintWriter(_Buffer);
		}

		/* ( Javadoc)
		 * @see javax.servlet.ServletResponse#getWriter()
		 */
		public PrintWriter getWriter() throws IOException {
			return _PrintWriter;
		}
		/* ( Javadoc)
		 * @see javax.servlet.http.HttpServletResponse#sendRedirect(java.lang.String)
		 */
		public void sendRedirect(String location) throws IOException {
			_Redirect_Location= location;
		}
		public String getRedirect() throws IOException {
			return _Redirect_Location;
		}

		/* ( Javadoc)
		 * @see java.lang.Object#toString()
		 */
		public String toString() {
			if (_ServlerError != HttpServletResponse.SC_OK) {
				StringBuffer sb= new StringBuffer();
				sb.append("<pre>");
				sb.append("JSPŃG[\n");
				sb.append("G[mF" + getSendError());
				sb.append("\nbZ[WF" + getSendErrorMsg());
				sb.append("</pre>");
				return sb.toString();
			}

			return _Buffer.toString();
		}

		private int _ServlerError= HttpServletResponse.SC_OK;
		private String _ServlerErrorMsg= "";
		/* ( Javadoc)
		 * @see javax.servlet.http.HttpServletResponse#sendError(int, java.lang.String)
		 */
		public void sendError(int arg0, String arg1) throws IOException {
			_ServlerError= arg0;
			_ServlerErrorMsg= arg1;
		}

		/* ( Javadoc)
		 * @see javax.servlet.http.HttpServletResponse#sendError(int)
		 */
		public void sendError(int arg0) throws IOException {
			sendError(arg0, "");
		}
		public int getSendError() {
			return _ServlerError;
		}
		public String getSendErrorMsg() {
			return _ServlerErrorMsg;
		}

		/* ( Javadoc)
		 * @see javax.servlet.ServletResponse#isCommitted()
		 */
		public boolean isCommitted() {
			return false;
		}

		/* ( Javadoc)
		 * @see javax.servlet.ServletResponse#getOutputStream()
		 */
		public ServletOutputStream getOutputStream() throws IOException {
			return  new Abc(_Buffer);
		}

	}
	class Abc extends ServletOutputStream{
		private ByteArrayOutputStream _Buffer=new ByteArrayOutputStream();
		Abc(ByteArrayOutputStream buffer){
			_Buffer=buffer;
		}
		/* ( Javadoc)
		 * @see java.io.OutputStream#write(int)
		 */
		public void write(int b) throws IOException {
			_Buffer.write(b);
		}
	}
	/* ( Javadoc)
	 * @see com.ponpo.portal.ForwardingURL#getFrowardURLWhenExec(javax.servlet.http.HttpServletRequest)
	 */
	public String getFrowardURLWhenExec(HttpServletRequest req) {
		return null;
	}
	class CgiRequest extends HttpServletRequestWrapper {

		/**
		 * @param arg0
		 */
		String _BaseUrl;
		String _BaseDir;
		String _CgiName;
		String _AddParm;
		public CgiRequest(HttpServletRequest arg0,String baseUrl,String baseDir,String cgiName,String addParam) {
			super(arg0);
			_BaseUrl=baseUrl;
			_BaseDir=baseDir;
			_CgiName=cgiName;
			_AddParm=addParam;
		}

		/* ( Javadoc)
		 * @see javax.servlet.http.HttpServletRequest#getPathInfo()
		 */
		public String getPathInfo() {
			String pathInfo=super.getContextPath()+super.getServletPath()+super.getPathInfo();
			int pos=getPathPos();
			if(pos>0){
				String cgiPath=pathInfo.substring(pos);
				if(cgiPath.startsWith(_BaseDir+"/")){
					return "/"+cgiPath;
				}else{
					return "/"+_BaseDir+"/"+cgiPath;
				}
			}else {
				return "/"+_BaseDir+"/"+_CgiName;
			}
		}
		private int getPathPos(){
			String pathInfo=super.getContextPath()+super.getServletPath()+super.getPathInfo();
		
			int pos=0;
			while(true){
				if(pos>=pathInfo.length()){
					pos=-1;
					break;
				}
				if(pos>=_BaseUrl.length()){
					break;
				}
				if(pathInfo.charAt(pos)==_BaseUrl.charAt(pos)){
					pos++;
				}else{
					break;
				}
			
			}
			return pos;
		}
		/* ( Javadoc)
		 * @see javax.servlet.http.HttpServletRequest#getServletPath()
		 */
		public String getServletPath() {
			String url=_BaseUrl;
			return url.substring(super.getContextPath().length());
		}

		/* ( Javadoc)
		 * @see javax.servlet.http.HttpServletRequest#getQueryString()
		 */
		public String getQueryString() {
			String param= super.getQueryString();
			if(getPathPos()>0){
			}else{
				if(_AddParm!=null && _AddParm.length()>0){
					if(param!=null && param.length()>0){
						param=param+"&"+_AddParm;
					}else{
						param=_AddParm;
					}
				}
			}
			return param;
		}

	}

}
