/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ponpo.portal.ActionInfo;
import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortletAction;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class ActionInfoDefineImpl implements ActionInfo {
	private static Log log = LogFactory.getLog(ActionInfoDefineImpl.class);

	private String _Name;
	private String _ClassName;
	private Map _Param=new HashMap();


	public ActionInfo cloneItem() {
		ActionInfoDefineImpl rtn=new ActionInfoDefineImpl();
		rtn._Name=this._Name;
		rtn._ClassName=this._ClassName;
		rtn._Param=new HashMap();
		rtn._Param.putAll(this._Param);
		return rtn;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @return
	 */
	public String getName() {
		return _Name;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @param string
	 */
	public void setActionClass(String string) {
		_ClassName = string;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @param string
	 */
	public void setName(String string) {
		_Name = string;
	}
	public String getParam(String key) {
		return (String) _Param.get(key);
	}
	public void removeParam(String key) {
		 _Param.remove(key);
	}
	public Iterator getParamKeys(){
		return _Param.keySet().iterator();
	}
	public void addParam(String name, String value) {
		_Param.put(name, value);
	}

	public PortletAction getPortletAction( ) throws PortalException{
		if(log.isDebugEnabled()){
			log.debug("Action Class:"+_ClassName);
		}
		Object portletObject;
		try {
			portletObject = Class.forName(_ClassName).newInstance();
		} catch (Exception e) {
			throw new PortalException(e);
		}

		if (portletObject instanceof PortletAction) {
			return (PortletAction) portletObject;
			
		}

		return null;
	}

	/* ( Javadoc)
	 * @see com.ponpo.portal.ActionInfo#getPortletActionName()
	 */
	public String getPortletActionName() {
		return _ClassName;
	}

	/* ( Javadoc)
	 * @see com.ponpo.portal.ActionInfo#getType()
	 */
	public String getType() {
		return "def";
	}

}
