/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import com.ponpo.portal.ActionInfo;
import com.ponpo.portal.ContextManager;
import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortletAction;
import com.ponpo.portal.PortletDefine;
import com.ponpo.portal.PortletManager;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class ActionInfoReferImpl implements ActionInfo {

	private String _Name;
	private String _ReferId;
	private Map _Param=new HashMap();

	public ActionInfo cloneItem() {
		ActionInfoReferImpl rtn=new ActionInfoReferImpl();
		rtn._Name=this._Name;
		rtn._ReferId=this._ReferId;
		rtn._Param=new HashMap();
		rtn._Param.putAll(this._Param);
		return rtn;
	}


	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @return
	 */
	public String getName() {
		return _Name;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @param string
	 */
	public void setReferId(String string) {
		_ReferId = string;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @param string
	 */
	public void setName(String string) {
		_Name = string;
	}
	public String getParam(String key) {
		String rtn=(String) _Param.get(key);
		if(rtn==null){
			ActionInfo actionInfo=getReferActionInfo();
			if (actionInfo != null){
				return actionInfo.getParam(key);
			}
		}
		return rtn;
	}
	public void removeParam(String key) {
		 _Param.remove(key);
	}
	public Iterator getParamKeys(){
		Map rtn=new HashMap();
		rtn.putAll(_Param);
		ActionInfo actionInfo=getReferActionInfo();
		if (actionInfo != null){
			for (Iterator iter = actionInfo.getParamKeys(); iter.hasNext();) {
				String key = (String) iter.next();
				rtn.put(key,actionInfo.getParam(key));
			}
		}
		
		return rtn.keySet().iterator();
	}
	public Iterator getOrignalParamKeys(){
		return _Param.keySet().iterator();
	}
	public void addParam(String name, String value) {
		_Param.put(name, value);
	}

	public PortletAction getPortletAction( ) throws PortalException{
		ActionInfo actionInfo=getReferActionInfo();
		if (actionInfo != null){
			return actionInfo.getPortletAction();
		}

		return null;
	}

	/* ( Javadoc)
	 * @see com.ponpo.portal.ActionInfo#getPortletActionName()
	 */
	public String getPortletActionName() {
		return _ReferId;
	}

	private ActionInfo getReferActionInfo(){
		PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
		PortletDefine define=portletManager.getPortletDefine(_ReferId);
		if (define != null){
			return define.getAction(_Name);
		}

		return null;
	}
	public String getType() {
		return "ref";
	}

	/* ( Javadoc)
	 * @see com.ponpo.portal.ActionInfo#setActionClass(java.lang.String)
	 */
	public void setActionClass(String string) {
		_ReferId=string;
	}

}
