/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import com.ponpo.portal.ActionInfo;
import com.ponpo.portal.PortletDefine;
import com.ponpo.portal.PortletParam;

/**
 * |[g[gACeB<BR>
 * <PRE>
 * |[g[gACeC^[tF[X̎܂B
 * getter,setterB
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class PortletDefineImpl  implements PortletDefine {
	private String _PortletId;
	private String _PortletName;
	private String _Role;
	private Map _ActionParam = new HashMap();
	private Map _PortletParam = new HashMap();
	private Map _MetaParam = new HashMap();
	
	public String getPortletId() {
		return _PortletId;
	}
	public void setPortletId(String string) {
		_PortletId = string;
	}
	public void setId(String string) {
		_PortletId = string;
	}

	public String getRole() {
		return _Role;
	}
	public void setRole(String string) {
		_Role = string;
	}


/*
 * Meta
 */
	/* ( Javadoc)
	 * @see com.ponpo.portal.PortletDefine#getMetaParam(java.lang.String)
	 */
	public String getMetaParam(String key) {
		return (String)_MetaParam.get(key);
	}
	/* ( Javadoc)
	 * @see com.ponpo.portal.PortletDefine#getMetaParamKeys()
	 */
	public Iterator getMetaParamKeys() {
		return _MetaParam.keySet().iterator();
	}

	public void addMetaParam(String name, String value) {
		_MetaParam.put(name, value);
	}
	/* ( Javadoc)
	 * @see com.ponpo.portal.PortletDefine#removeMetaParam(java.lang.String)
	 */
	public void removeMetaParam(String name) {
		_MetaParam.remove(name);
	}


/*
 *  Action
 */
	public void addAction(ActionInfo actionInfo) {
		_ActionParam.put(actionInfo.getName(), actionInfo);
	}
	public void removeAction(String key) {
		_ActionParam.remove(key);
	}

	public ActionInfo getAction(String name) {
		Object obj=_ActionParam.get(name);
		if(obj==null){
			return null;
		}
		return (ActionInfo)obj;
	}
	public Iterator getActionKeys() {
		return _ActionParam.keySet().iterator();
	}
	public void removeAction(ActionInfo actionInfo) {
		_ActionParam.remove(actionInfo.getName());
	}
	/* ( Javadoc)
	 * @see com.ponpo.portal.PortletDefine#newDefAction()
	 */
	public ActionInfo newAction(String type) {
		if(type.equals("def")){
			return new ActionInfoDefineImpl();
		}else{
			return new ActionInfoReferImpl();
		}
	}

/*
 *  PortletParam
 */
	public PortletParam getPortletParam(String key) {
		return (PortletParam) _PortletParam.get(key);
	}
	public Iterator getPortletParamKeys(){
		return _PortletParam.keySet().iterator();
	}
	public void addPortletParam(PortletParam portletParam) {
		_PortletParam.put(portletParam.getName(), portletParam);
	}
	public PortletParam newPortletParam() {
		return new PortletParamImpl();
	}
	public void removePortletParam(PortletParam portletParam) {
		_PortletParam.remove(portletParam.getName());
	}

	/*
	 *  PortletName
	 */
	public String getPortletName() {
		return _PortletName;
	}

	public void setPortletName(String string) {
		_PortletName = string;
	}
	public void setName(String string) {
		_PortletName = string;
	}
}
