/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import com.ponpo.portal.ActionInfo;
import com.ponpo.portal.PortletItem;

/**
 * |[g[gACeB<BR>
 * <PRE>
 * |[g[gACeC^[tF[X̎܂B
 * getter,setterB
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class PortletItemImpl  implements PortletItem,Cloneable {
	private Map _PortletDatas = new HashMap();
	protected Collection _Leaf = new ArrayList();
	protected String _ReadRole;
	protected String _EditRole;
	protected String _Label;
	protected String _Id;
	protected Map _SystemDatas=new HashMap();
	protected ActionInfo _ActionInfo;
	private String _Name;

	public String getId() {
		return _Id;
	}

	public String getLabel() {
		return _Label;
	}

	public Collection getLeaf() {
		return _Leaf;
	}


	public void setId(String string) {
		_Id = string;
	}

	public void setLabel(String string) {
		_Label = string;
	}

	public void setLeaf(Collection collection) {
		_Leaf = collection;
	}


	public void add(Object portlet) {
		_Leaf.add(portlet);
	}
	public void setName(String string) {
		_Name = string;
	}

	public Object getSystemData(String key) {
		return _SystemDatas.get(key);
	}

	public void addSystemData(String key, Object data) {
		 _SystemDatas.put(key,data);		
	}
	public Iterator getSystemDataKeys(){
		return _SystemDatas.keySet().iterator();
	}

	
	
	public PortletItem cloneItem() {
		try {
			PortletItem rtn=(PortletItem) this.clone();
			Map map=_SystemDatas;
			_SystemDatas=new HashMap();
			_SystemDatas.putAll(map );
			return rtn;
		} catch (CloneNotSupportedException e) {
			return null;
		}
	}

	public void addPortletParam(String name, String value) {
		_PortletDatas.put(name, value);
	}
	public void removePortletParam(String name) {
		_PortletDatas.remove(name);
	}

	public String getPortletParam(String key) {
		return (String) _PortletDatas.get(key);
	}

	public Iterator getPortletParamKeys(){
		return _PortletDatas.keySet().iterator();
	}


	public String getPortletName() {
		return _Name;
	}
	public void setPortletName(String string) {
		_Name=string;
	}

	public String toString() {
		StringBuffer sb=new StringBuffer();
		sb.append("\n NAME:");
		sb.append(_Name);
		sb.append(" ID:");
		sb.append(_Id);
		sb.append(" ReadROLE:");
		sb.append(_ReadRole);
		sb.append(" EditROLE:");
		sb.append(_EditRole);
		sb.append(" LABEL:");
		sb.append(_Label);
		
		return sb.toString();
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @return
	 */
	public String getEditRole() {
		return _EditRole;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @return
	 */
	public String getReadRole() {
		return _ReadRole;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @param string
	 */
	public void setEditRole(String string) {
		_EditRole = string;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @param string
	 */
	public void setReadRole(String string) {
		_ReadRole = string;
	}


	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @return
	 */
	public ActionInfo getActionInfo() {
		return _ActionInfo;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @param info
	 */
	public void setActionInfo(ActionInfo info) {
		_ActionInfo = info;
	}

	/* ( Javadoc)
	 * @see com.ponpo.portal.PortletItem#getParamData(java.lang.String)
	 */
	public Object getParamData(String key) {
		Object obj=_SystemDatas.get(key);
		if(obj==null){
			obj=_PortletDatas.get(key);
		}
		return obj;
	}

	/* ( Javadoc)
	 * @see com.ponpo.portal.PortletItem#getStrParam(java.lang.String)
	 */
	public String getStrParam(String key) {
		try {
			return (String)getParamData(key);
		} catch (ClassCastException e) {
			return null;
		}
	}

}
