/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import com.ponpo.portal.PortletParam;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class PortletParamImpl implements PortletParam {
	private String _Name;
	private String _Value;
	private Map _ParamMap=new HashMap();

	public String getParam(String key) {
		return (String)_ParamMap.get(key);
	}

	public Iterator getParamKeys() {
		return _ParamMap.keySet().iterator();
	}
	public void addParam(String key,String value) {
		_ParamMap.put(key,value);
	}
	public void removeParam(String key) {
		_ParamMap.remove(key);
	}

	public String getName() {
		return _Name;
	}
	public void setName(String string) {
		_Name = string;
	}

	public String getValue() {
		return _Value;
	}
	public void setValue(String string) {
		_Value = string;
	}

	public PortletParam cloneItem() {
		PortletParamImpl rtn=new PortletParamImpl();
		rtn._Name=this._Name;
		rtn._Value=this._Value;
		rtn._ParamMap=new HashMap();
		rtn._ParamMap.putAll(this._ParamMap);
		return rtn;
	}

}
