/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortletStyle;
import com.ponpo.portal.PortletStyleAction;

/**
 * |[g[gACeB<BR>
 * <PRE>
 * |[g[gACeC^[tF[X̎܂B
 * getter,setterB
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class PortletStyleImple  implements PortletStyle {
	private String _SytleId;
	private String _SytleName;
	private String _StyleClassName;
	private Map _Param = new HashMap();
	

	public void setSytleId(String string) {
		_SytleId = string;
	}
	public void setId(String string) {
		_SytleId = string;
	}
	public String getSytleId() {
		return _SytleId;
	}

	public void setStyleClass(String string) {
		_StyleClassName = string;
	}
	public String getSytleActionClass() throws PortalException {
		return _StyleClassName;
	}
	public PortletStyleAction getSytleAction() throws PortalException {

		Object portletObject;
		try {
			portletObject = Class.forName(_StyleClassName).newInstance();
		} catch (Exception e) {
			throw new PortalException(e);
		}

		if (portletObject instanceof PortletStyleAction) {
			return (PortletStyleAction) portletObject;

		}

		return null;
	}

	public void addParam(String name, String value) {
		_Param.put(name, value);
	}
	public String getParam(String key) {
		return (String) _Param.get(key);
	}
	public Iterator getParamKeys() {
		return _Param.keySet().iterator();
	}
	public void removeParam(String key) {
		_Param.remove(key);
	}

	public String getSytleName() {
		return _SytleName;
	}
	public void setSytleName(String string) {
		_SytleName = string;
	}
	public void setName(String string) {
		_SytleName = string;
	}

}
