/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.impl.file;

import java.util.HashMap;
import java.util.Map;

import com.ponpo.parse.xml.BaseDigester;
import com.ponpo.portal.PortletDefine;



/**
 * Portal`XMĹB<BR>
 * <UL>
 * Portal`̉͂s܂B<BR>
 * </UL>
 * @since 1.0.0
 * @version 1.00.00
 * @author Yoshi Sasaki
 */
public class ParsePortletDefine extends ParseBase{

	public void setDetailRule(BaseDigester digester){
		digester.addObjectCreate("*/portlet", "com.ponpo.portal.impl.PortletDefineImpl");
		digester.addSetProperties("*/portlet");

		digester.addSetProperties("*/portlet/meta");
		digester.addCallMethod("*/portlet/meta/param", "addMetaParam", 2);
		digester.addCallParam("*/portlet/meta/param",  0, "name");
		digester.addCallParam("*/portlet/meta/param",  1, "value");

		digester.addObjectCreate("*/portlet/actionDef", "com.ponpo.portal.impl.ActionInfoDefineImpl");
		digester.addSetProperties("*/portlet/actionDef");
		digester.addCallMethod("*/portlet/actionDef/param", "addParam", 2);
		digester.addCallParam("*/portlet/actionDef/param",  0, "name");
		digester.addCallParam("*/portlet/actionDef/param",  1, "value");
		digester.addSetNext("*/portlet/actionDef", "addAction","com.ponpo.portal.ActionInfo");

		digester.addObjectCreate("*/portlet/actionRef", "com.ponpo.portal.impl.ActionInfoReferImpl");
		digester.addSetProperties("*/portlet/actionRef");
		digester.addCallMethod("*/portlet/actionRef/param", "addParam", 2);
		digester.addCallParam("*/portlet/actionRef/param",  0, "name");
		digester.addCallParam("*/portlet/actionRef/param",  1, "value");
		digester.addSetNext("*/portlet/actionRef", "addAction","com.ponpo.portal.ActionInfo");

		digester.addObjectCreate("*/portlet/portletParam/dataDef", "com.ponpo.portal.impl.PortletParamImpl");
		digester.addSetProperties("*/portlet/portletParam/dataDef");
		digester.addCallMethod("*/portlet/portletParam/dataDef/param", "addParam", 2);
		digester.addCallParam("*/portlet/portletParam/dataDef/param",  0, "name");
		digester.addCallParam("*/portlet/portletParam/dataDef/param",  1, "value");
		digester.addSetNext("*/portlet/portletParam/dataDef", "addPortletParam","com.ponpo.portal.PortletParam");

		digester.addSetNext("*/portlet", "add");

	}
	private Map _Map=new HashMap();
	public void add(Object tag){
		PortletDefine item=(PortletDefine)tag;
		_Map.put(item.getPortletId(),tag);	
	}
	/* ( Javadoc)
	 * @see com.ponpo.portal.parse.ParseBase#getReturnData()
	 */
	protected Object getReturnData() {
		return _Map ;
	}
}
