/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.impl.file;

import java.util.HashMap;
import java.util.Map;

import com.ponpo.parse.xml.BaseDigester;
import com.ponpo.portal.PortletStyle;



/**
 * PortletX^CXMĹB<BR>
 * <UL>
 * PortletX^C̉͂s܂B<BR>
 * </UL>
 * @since 1.0.0
 * @version 1.00.00
 * @author Yoshi Sasaki
 */
public class ParsePortletStyle extends ParseBase{

	private Map _Map=new HashMap();
	public void add(Object tag){
		PortletStyle item=(PortletStyle)tag;
		_Map.put(item.getSytleId(),tag);	
	}

	/* ( Javadoc)
	 * @see com.ponpo.portal.parse.ParseBase#setDetailRule(com.ponpo.portal.parse.BaseDigester)
	 */
	public void setDetailRule(BaseDigester digester) {
		digester.addObjectCreate("*/define", "com.ponpo.portal.impl.PortletStyleImple");
		digester.addSetProperties("*/define");

		digester.addSetProperties("*/define");
		digester.addCallMethod("*/define/param", "addParam", 2);
		digester.addCallParam("*/define/param",  0, "name");
		digester.addCallParam("*/define/param",  1, "value");

		digester.addSetNext("*/define", "add");
		
	}

	/* ( Javadoc)
	 * @see com.ponpo.portal.parse.ParseBase#getReturnData()
	 */
	protected Object getReturnData() {
		return _Map ;
	}
}
