/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.impl.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.ServletConfig;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortletDefine;
import com.ponpo.portal.PortletItem;
import com.ponpo.portal.PortletManager;
import com.ponpo.portal.PortletStyle;
import com.ponpo.portal.impl.PortletDefineImpl;
import com.ponpo.portal.impl.PortletItemImpl;
import com.ponpo.portal.impl.PortletStyleImple;
import com.ponpo.portal.util.Environment;
import com.ponpo.portal.util.FileUtils;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class PortletManagerImpl implements PortletManager{
	private  Log log = LogFactory.getLog(PortletManagerImpl.class);

	private  File  _PortalPath;

	public PortletManagerImpl(ServletConfig config) throws Exception{
		_PortalPath=Environment.getRealPath("WEB-INF/data/portals/");
		

		InputStream  stream;
		stream = Environment.getResourceAsStream("WEB-INF/data/config/portletDefine.xml");

		ParsePortletDefine parse = new ParsePortletDefine();
		_PortletDefine=(Map)parse.loadXMLData(stream);
		stream.close();
		stream = Environment.getResourceAsStream("WEB-INF/data/config/styleDefine.xml");

		ParsePortletStyle parseStyle = new ParsePortletStyle();
		_PortletStyle=(Map)parseStyle.loadXMLData(stream);
		stream.close();

	}

/*
 * Portal
 */
	private  Map  _Portal=new HashMap();
	public PortletItem newPortletItem() {
		return new PortletItemImpl();
	}
	public  PortletItem getPortal(String portalName) throws PortalException{
		PortletItem item=(PortletItem)_Portal.get(portalName);
		if(item==null){
			item=loadPortal(portalName);
			_Portal.put(portalName,item);
		}
		return item;
	}
	public void removePortal(String portalName) throws PortalException{
		File removeFile=new File(_PortalPath,portalName+".xml");
		try {
			FileUtils.treeDel(removeFile);
			_Portal.remove(portalName);
		} catch (IOException e) {
			throw new PortalException(e);
		}
	}
	public void copyPortal(String fromPortal,String  toPotal) throws PortalException{
		File fromFname=new File(_PortalPath,fromPortal+".xml");
		File toFname=new File(_PortalPath,toPotal+".xml");
		try {
			InputStream ins = new FileInputStream(fromFname);;
			OutputStream outs = new FileOutputStream(toFname);
			
			byte buff[]=new byte[256];
			int size;
			while( (size=ins.read(buff) )!=-1){
				outs.write(buff,0,size);
			}
			ins.close();
			outs.close(); 

		} catch (IOException e) {
			log.fatal("",e);
			throw new PortalException(e);
		}
	}
	public Iterator getPortalKeys(){
		String[] fileList=_PortalPath.list();
		Collection col=new ArrayList();
		for (int cnt = 0; cnt < fileList.length; cnt++) {
			if(fileList[cnt].endsWith(".xml")){
				col.add(fileList[cnt].substring(0,fileList[cnt].length()-4));
			}
		}
		return col.iterator();
	}
	private  PortletItem loadPortal(String portalName) throws PortalException{
		try {
			ParsePortal parse = new ParsePortal();
			return (PortletItem)parse.loadXMLData(new File(_PortalPath,portalName+".xml"));
		} catch (IOException e) {
			log.fatal("",e);
			throw new PortalException(e);
		} catch (SAXException e) {
			log.fatal("",e);
			throw new PortalException(e);
		}
	}
	public void savePortal(String portalName) throws PortalException {
		try {

			WritePortal portal=new WritePortal();
			portal.doWrite(portalName);
		} catch (IOException e) {
			throw new PortalException(e);
		}
	}


	/*
	 * PortletDefine
	 */

	private  Map  _PortletDefine=new HashMap();
	
	
	public PortletDefine newPortletDefine(String portletId) {
		PortletDefine rtn=getPortletDefine(portletId);
		if(rtn==null){
			PortletDefineImpl portletDefineImpl=new PortletDefineImpl();
			portletDefineImpl.setId(portletId);
			rtn=portletDefineImpl;
			setPortletDefine(rtn);
		}
		return rtn;
	}
	public void setPortletDefine(PortletDefine portletDefine){
		if(portletDefine!=null){
			_PortletDefine.put(portletDefine.getPortletId(),portletDefine);
		}
	}
	public  PortletDefine getPortletDefine(String portletId){
		return (PortletDefine)_PortletDefine.get(portletId);
	}
	public  Iterator getPortletDefinesKeys(){
		return _PortletDefine.keySet().iterator();
	}
	public void removePortletDefine(PortletDefine portletDefine) {
		if(portletDefine!=null){
			_PortletDefine.remove(portletDefine.getPortletId());
		}
	}
	public void savePortletDefine() throws PortalException {
		try {

			WritePortalDefine portal=new WritePortalDefine();
			portal.doWrite();
		} catch (IOException e) {
			throw new PortalException(e);
		}
	}


	/*
	 * PortletStyle
	 */

	private  Map  _PortletStyle=new HashMap();
	public PortletStyle newPortletStyle(String portalStyleId) throws PortalException {
		PortletStyle rtn=getPortletStyle(portalStyleId);
		if(rtn==null){
			rtn=new PortletStyleImple();
			setPortletStyle(rtn);
		}
		return rtn;
	}
	public PortletStyle getPortletStyle( String portalStyleId) {
			return (PortletStyle)_PortletStyle.get(portalStyleId);
	}
	public Iterator getPortletStyleKeys() throws PortalException {
		return _PortletStyle.keySet().iterator();
	}
	public void removePortletStyle(PortletStyle portletStyle) {
		if(portletStyle!=null){
			_PortletStyle.remove(portletStyle.getSytleId());
		}
	}
	public void setPortletStyle(PortletStyle portletStyle) throws PortalException {
		if(portletStyle!=null){
			_PortletStyle.put(portletStyle.getSytleId(),portletStyle);
		}
	}
	public void savePortletStyle() throws PortalException {
		try {

			WritePortalStyle portal=new WritePortalStyle();
			portal.doWrite();
		} catch (IOException e) {
			throw new PortalException(e);
		}
	}

}
