/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.impl.file;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

import org.apache.commons.modeler.Registry;

import com.ponpo.portal.PortalException;
import com.ponpo.portal.UserManager;
import com.ponpo.portal.util.StringUtils;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class UserManagerImpl implements UserManager {
	private String GUEST_PORTAL="guest";
	private Map _User=new HashMap();
	private String _DataFileName;
	public UserManagerImpl(ServletConfig config) throws Exception{
		ServletContext context=config.getServletContext();
		_DataFileName=context.getRealPath("WEB-INF/data/user/portal.data");
		FileInputStream propStream=new FileInputStream(_DataFileName);
		Properties	prop=new Properties();
		prop.load(propStream);
		Enumeration enum=prop.propertyNames();
		while (enum.hasMoreElements()) {
			String key=(String)enum.nextElement();
			String values=prop.getProperty(key);
			_User.put(key,getUsePortlet(values));
		}
		propStream.close();
	}

	private Collection getUsePortlet(String portalName){
		List col=new ArrayList();
		if(portalName!=null){
			String[] portalNames=StringUtils.cnvComma2Array(portalName);
			for (int cnt = 0; cnt < portalNames.length; cnt++) {
				col.add(portalNames[cnt]);
			}
		}
		return col;
		
	}
	public String getStartPortal(String userID){
		if(userID==null){
			return GUEST_PORTAL;
		}
		String rtn=GUEST_PORTAL;
		List values=(List)_User.get(userID);
		if(values!=null && !values.isEmpty()){
			rtn=(String)values.get(0);
		}
		return rtn;
	}

	/* ( Javadoc)
	 * @see com.ponpo.portal.UserManager#enableUsePortal(java.lang.String)
	 */
	public Iterator getEnablePortals(String userID) {
		List values=(List)_User.get(userID);
		if(values==null || values.isEmpty()){
			values=new ArrayList();
			values.add(GUEST_PORTAL);
		}
		return values.iterator();
	}

	/* ( Javadoc)
	 * @see com.ponpo.portal.UserManager#setStartPortal(java.lang.String, java.lang.String)
	 */
	public void setStartPortal(String userID, String portalName) throws PortalException {
		List values=(List)_User.get(userID);
		values.remove(portalName);
		values.add(0,portalName);
		writeData();
	}
	public void removePortal(String portalName) throws PortalException {
		for (Iterator iter = _User.keySet().iterator(); iter.hasNext();) {
			String userID = (String) iter.next();
			Collection col=(Collection)_User.get(userID);
			col.remove(portalName);
			if(col.isEmpty()){
				_User.remove(userID);
				removePortal(portalName);
				break;
			}else{
				if(col.size()==1){
					String val=(String)col.iterator().next();
					if(val.equals(GUEST_PORTAL)){
						_User.remove(userID);
						removePortal(portalName);
						break;
					}
				}
			}
		}
		writeData();
	}
	/* ( Javadoc)
	 * @see com.ponpo.portal.UserManager#setStartPortal(java.lang.String, java.lang.String)
	 */
	public void setPortal(String userID, String portalNames) throws PortalException {
		Collection col=getUsePortlet(portalNames);
		if(col.isEmpty()){
			_User.remove(userID);
		}else{
			if(col.size()==1){
				String val=(String)col.iterator().next();
				if(val.equals(GUEST_PORTAL)){
					_User.remove(userID);
				}else{
					_User.put(userID,col);
				}
			}else{
				_User.put(userID,col);
			}
		}
		writeData();
	}
	private void writeData() throws PortalException{
		try {
			Map map=new HashMap();
			for (Iterator iter = _User.keySet().iterator(); iter.hasNext();) {
				String key = (String) iter.next();
				List list=(List)_User.get(key);
				StringBuffer sb=new StringBuffer();
				for (Iterator iterator = list.iterator();iterator.hasNext();) {
					sb.append(",");
					sb.append(iterator.next());
				}
				String work=sb.toString();
				if(work.length()>0){
					map.put(key,work.substring(1));
				}else{
					map.put(key,"");
				}
			}
			
			Properties	prop=new Properties();
			prop.putAll(map);

			FileOutputStream fos=new FileOutputStream(_DataFileName);
			prop.save(fos,"UserManeger Write");
			fos.close();
		} catch (IOException e) {
			throw new PortalException(e);
		}


	}
	public Iterator getRoles()throws PortalException{
		MBeanServer mserver =(MBeanServer)Registry.getServer();
		ObjectName dname;
		try {
			String accessKey="Users:type=UserDatabase,database=UserDatabase";
			String databaseName =URLDecoder.decode( accessKey);
			dname = new ObjectName(databaseName);
			String results[] =(String[]) mserver.getAttribute(dname, "roles");
			Collection col=new ArrayList();
			for (int cnt = 0; cnt < results.length; cnt++) {
				//Users:type=Role,rolename=user,database=UserDatabase
				String words[]=StringUtils.cnvComma2Array(results[cnt]);
				col.add(words[1].substring(9));
			}
			return col.iterator();
		} catch (Exception e) {
			throw new PortalException(e);
		}

	}
	public Iterator getUsers()throws PortalException{
		MBeanServer mserver =(MBeanServer)Registry.getServer();
		ObjectName dname;
		try {
			String accessKey="Users:type=UserDatabase,database=UserDatabase";
			String databaseName =URLDecoder.decode( accessKey);
			dname = new ObjectName(databaseName);
			String results[] =(String[]) mserver.getAttribute(dname, "users");
			Collection col=new ArrayList();
			for (int cnt = 0; cnt < results.length; cnt++) {
				//Users:type=User,username=tomcat,database=UserDatabase
				String words[]=StringUtils.cnvComma2Array(results[cnt]);
				col.add(words[1].substring(9));
			}
			return col.iterator();
		} catch (Exception e) {
			throw new PortalException(e);
		}

	}

}
