/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.impl.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;

import com.ponpo.portal.ContextManager;
import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortletItem;
import com.ponpo.portal.PortletManager;
import com.ponpo.portal.util.Environment;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
class WritePortal extends XMLWriteBase {
	public void doWrite(String portalName) throws IOException, PortalException{

		File makefile=Environment.getRealPath( "/WEB-INF/data/portals/"+portalName+".xml");
		FileOutputStream fos=new FileOutputStream(makefile);
		OutputStreamWriter osw=new OutputStreamWriter(fos,Charset.forName("utf-8"));
		PrintWriter pw=new PrintWriter(osw);
		getHead(pw);
		pw.println("<portal>");
		PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");

		writePortlet(portletManager.getPortal(portalName),pw,0);
		pw.println("</portal>");
		pw.close() ;
		fos.close();
	}


	private void writePortlet(PortletItem parentItem,PrintWriter pw,int indent)throws IOException{

		writeIndent(pw,indent);
		pw.println(
		"<portlet "
		+getElement("name",parentItem.getPortletName())
		+getElement("id",parentItem.getId())
		+getElement("label",parentItem.getLabel())
		+getElement("readRole",parentItem.getReadRole())
		+getElement("editRole",parentItem.getEditRole())
		+">"
		);
		for (Iterator iter = parentItem.getPortletParamKeys(); iter.hasNext();) {
			String key = (String) iter.next();
			String value = (String) parentItem.getPortletParam(key);
			writeIndent(pw,indent+1);
			pw.println(
			"<param "
			+getElement("name",key)
			+getElement("value",value)
			+"/>"
			);
			
		} 
		Collection items=parentItem.getLeaf();
		for (Iterator iter = items.iterator(); iter.hasNext();) {
			PortletItem leafItem = (PortletItem) iter.next();
			writePortlet(leafItem,pw,indent+1);
		} 

		writeIndent(pw,indent);
		pw.println("</portlet> ");
	}

	private void getHead(PrintWriter pw){
		pw.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
		pw.println("");
		pw.println("<!DOCTYPE portal");
		pw.println(" PUBLIC \"-//Portal//DTD Config Design//EN\"");
		pw.println(" \"/WEB-INF/dtd/portal_1_1.dtd\">");
		pw.println("");
	}


}
