/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.impl.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Iterator;

import com.ponpo.portal.ActionInfo;
import com.ponpo.portal.ContextManager;
import com.ponpo.portal.PortletDefine;
import com.ponpo.portal.PortletManager;
import com.ponpo.portal.PortletParam;
import com.ponpo.portal.impl.ActionInfoReferImpl;
import com.ponpo.portal.util.Environment;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
class WritePortalDefine extends XMLWriteBase {
	public void doWrite() throws IOException{

		File makefile=Environment.getRealPath( "/WEB-INF/data/config/portletDefine.xml");

		FileOutputStream fos=new FileOutputStream(makefile);
		OutputStreamWriter osw=new OutputStreamWriter(fos,Charset.forName("utf-8"));
		PrintWriter pw=new PrintWriter(osw);
		getHead(pw);

		pw.println("<portletDefine>");
		PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
		for (Iterator iter = portletManager.getPortletDefinesKeys(); iter.hasNext();) {
			String defineKey=(String)iter.next();
			PortletDefine portletDefine=(PortletDefine)portletManager.getPortletDefine(defineKey);
			writePortletDefine(portletDefine,pw,0);
		}
		pw.println("</portletDefine>");
		pw.close() ;
		fos.close();
	}

	private void writePortletDefine(PortletDefine defineItem,PrintWriter pw,int indent)throws IOException{

		writeIndent(pw,indent);
		pw.println(	"<portlet "	
			+getElement("id",defineItem.getPortletId())
			+getElement("name",defineItem.getPortletName())
			+getElement("role",defineItem.getRole())+">");
		if(defineItem.getMetaParamKeys().hasNext()){
			writeIndent(pw,indent+1);
			pw.println(	"<meta>");
			for (Iterator iter = defineItem.getMetaParamKeys(); iter.hasNext();) {
				String key = (String) iter.next();
				String value = (String) defineItem.getMetaParam(key);
				writeIndent(pw,indent+2);
				pw.println(	"<param "+getElement("name",key)+getElement("value",value)+"/>");
			} 
			writeIndent(pw,indent+1);
			pw.println(	"</meta>");
		}

		if(defineItem.getActionKeys().hasNext()){
			for (Iterator actionIter = defineItem.getActionKeys(); actionIter.hasNext();) {
				String actionKey = (String) actionIter.next();
	
				writeIndent(pw,indent+1);
				ActionInfo actionInfo=defineItem.getAction(actionKey);
				if(actionInfo.getType().equals("def")){
					pw.println(	"<actionDef "+getElement("name",actionKey)+getElement("actionClass",actionInfo.getPortletActionName())+">");
				}else{
					pw.println(	"<actionRef "+getElement("referId",actionInfo.getPortletActionName())+">");
				}
				Iterator iter;
				if(actionInfo instanceof ActionInfoReferImpl){
					ActionInfoReferImpl actionInfoReferImpl=(ActionInfoReferImpl)actionInfo;
					iter = actionInfoReferImpl.getOrignalParamKeys();
				}else{
					iter = actionInfo.getParamKeys();
				}
				while (iter.hasNext()) {
					String key = (String) iter.next();
					String value = (String) actionInfo.getParam(key);
					writeIndent(pw,indent+2);
					pw.println(	"<param "+getElement("name",key)+getElement("value",value)+"/>");
					
				}
				writeIndent(pw,indent+1);
				if(actionInfo.getType().equals("def")){
					pw.println(	"</actionDef>");
				}else{
					pw.println(	"</actionRef>");
				}
			}
		}
		if(defineItem.getPortletParamKeys().hasNext()){
			writeIndent(pw,indent+1);
			pw.println(	"<portletParam>");
			for (Iterator iter = defineItem.getPortletParamKeys(); iter.hasNext();) {
				String key = (String) iter.next();
				PortletParam portletParam=defineItem.getPortletParam(key);

				writeIndent(pw,indent+2);
				Iterator iterator = portletParam.getParamKeys();
				if(iterator.hasNext()){
					pw.println(	"<dataDef "+getElement("name",portletParam.getName())+getElement("value",portletParam.getValue())+">");
					while(iterator.hasNext()) {
							String element = (String) iterator.next();
							String value = (String) portletParam.getParam(element);
							writeIndent(pw,indent+3);
							pw.println(	"<param "+getElement("name",element)+getElement("value",value)+"/>");
					}
					writeIndent(pw,indent+2);
					pw.println(	"</dataDef>");
				}else{
					pw.println(	"<dataDef "+getElement("name",portletParam.getName())+getElement("value",portletParam.getValue())+"/>");
				}

			} 
			writeIndent(pw,indent+1);
			pw.println(	"</portletParam>");
		}

		writeIndent(pw,indent);
		pw.println("</portlet> ");
	}


	private void getHead(PrintWriter pw){
		pw.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
		pw.println("");
		pw.println("<!DOCTYPE portletDefine");
		pw.println(" PUBLIC \"-//Portal//DTD Config Design//EN\"");
		pw.println(" \"/WEB-INF/dtd/portletDefine_1_0.dtd\">");
		pw.println("");
	}

}
