/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.impl.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Iterator;

import com.ponpo.portal.ContextManager;
import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortletManager;
import com.ponpo.portal.PortletStyle;
import com.ponpo.portal.util.Environment;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
class WritePortalStyle extends XMLWriteBase {
	public void doWrite() throws PortalException, IOException{

		File makefile=Environment.getRealPath( "/WEB-INF/data/config/styleDefine.xml");

		FileOutputStream fos=new FileOutputStream(makefile);
		OutputStreamWriter osw=new OutputStreamWriter(fos,Charset.forName("utf-8"));
		PrintWriter pw=new PrintWriter(osw);
		getHead(pw);

		pw.println("<styleDefine>");
		PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
		for (Iterator iter = portletManager.getPortletStyleKeys(); iter.hasNext();) {
			String defineKey=(String)iter.next();
			PortletStyle styleDefine=(PortletStyle)portletManager.getPortletStyle(defineKey);
			writePortletStyle(styleDefine,pw,0);
		}
		pw.println("</styleDefine>");
		pw.close() ;
		fos.close();
	}

	private void writePortletStyle(PortletStyle styleDefine,PrintWriter pw,int indent)throws IOException, PortalException{


		writeIndent(pw,indent);
		pw.println(	"<define "
			+getElement("id",styleDefine.getSytleId())
			+getElement("name",styleDefine.getSytleName())
			+getElement("styleClass",styleDefine.getSytleActionClass())+">");
		for (Iterator iter = styleDefine.getParamKeys(); iter.hasNext();) {
			String key = (String) iter.next();
			String value = (String) styleDefine.getParam(key);
			writeIndent(pw,indent+1);
			pw.println(	"<param "+getElement("name",key)+getElement("value",value)+"/>");
		} 
		writeIndent(pw,indent);
		pw.println("</define> ");
	}


	private void getHead(PrintWriter pw){
		pw.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
		pw.println("");
		pw.println("<!DOCTYPE styleDefine");
		pw.println(" PUBLIC \"-//Portal//DTD Config Design//EN\"");
		pw.println(" \"/WEB-INF/dtd/styleDefine_1_0.dtd\">");
		pw.println("");
	}

}
