/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.impl.file;

import java.io.PrintWriter;

import com.ponpo.portal.util.StringUtils;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class XMLWriteBase {
	protected final String getElement(String key,String value){
		return getElement(key,value,false);
	}
	protected final String getElement(String key,String value,boolean flag){
		if(value==null){
			return "";
		}
		if(value.length()==0){
			return "";
		}
		String rtn;
		if(flag){
			rtn=key +"="+((value==null)?"\"\"":"<![CDATA[" + value+"]]> ");
		}else{
			rtn=key +"=\""+((value==null)?"":StringUtils.cnvHtmlStr( value))+"\" ";
		}
		return rtn;
	}
	protected void writeIndent(PrintWriter pw,int indent){
		for(int cnt=0;cnt<indent;++cnt){
			pw.print("\t");
		}
	}

}
