/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.req.parser;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;


/**
 * NGXg[eBB<BR>
 * <PRE>
 * NGXgɊւẴ[eBłB
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class RequestDecoder {

	private ByteChunk _TmpName = new ByteChunk();
	private ByteChunk _TmpValue = new ByteChunk();
	private UDecoder _UrlDec;
	private Map _DataMap = new Hashtable();

	public RequestDecoder(HttpServletRequest req) {
		if(req.getQueryString()!=null){
			byte buffer[] = req.getQueryString().getBytes();
			processParameters(buffer, 0, buffer.length, req.getCharacterEncoding());
		}
	}
	public String[] getParameterValues(String name) {
		return (String[]) _DataMap.get(name);
	}

	public String getParameter(String name) {
		String[] values = getParameterValues(name);
		if (values != null) {
			if (values.length == 0)
				return "";
			return values[0];
		} else {
			return null;
		}
	}
	private void processParameters(
		byte bytes[],
		int start,
		int len,
		String enc) {
		int end = start + len;
		int pos = start;

		do {
			boolean noEq = false;
			int valStart = -1;
			int valEnd = -1;

			int nameStart = pos;
			int nameEnd = ByteChunk.indexOf(bytes, nameStart, end, '=');
			// Workaround for a&b&c encoding
			int nameEnd2 = ByteChunk.indexOf(bytes, nameStart, end, '&');
			if ((nameEnd2 != -1) && (nameEnd == -1 || nameEnd > nameEnd2)) {
				nameEnd = nameEnd2;
				noEq = true;
				valStart = nameEnd;
				valEnd = nameEnd;
			}
			if (nameEnd == -1)
				nameEnd = end;

			if (!noEq) {
				valStart = (nameEnd < end) ? nameEnd + 1 : end;
				valEnd = ByteChunk.indexOf(bytes, valStart, end, '&');
				if (valEnd == -1)
					valEnd = (valStart < end) ? end : valStart;
			}

			pos = valEnd + 1;

			if (nameEnd <= nameStart) {
				continue;
				// invalid chunk - it's better to ignore
				// XXX log it ?
			}
			_TmpName.setBytes(bytes, nameStart, nameEnd - nameStart);
			_TmpValue.setBytes(bytes, valStart, valEnd - valStart);

			try {
				addParam(urlDecode(_TmpName, enc), urlDecode(_TmpValue, enc));
			} catch (IOException e) {
				// Exception during character decoding: skip parameter
			}

			_TmpName.recycle();
			_TmpValue.recycle();

		} while (pos < end);
	}
	private String urlDecode(ByteChunk bc, String enc) throws IOException {
		if (_UrlDec == null) {
			_UrlDec = new UDecoder();
		}
		_UrlDec.convert(bc);
		String result = null;
		if (enc != null) {
			bc.setEncoding(enc);
			result = bc.toString();
		}
		return result;
	}
	private void addParam(String key, String value) {
		if (key == null)
			return;
		String values[];
		if (_DataMap.containsKey(key)) {
			String oldValues[] = (String[]) _DataMap.get(key);
			values = new String[oldValues.length + 1];
			for (int i = 0; i < oldValues.length; i++) {
				values[i] = oldValues[i];
			}
			values[oldValues.length] = value;
		} else {
			values = new String[1];
			values[0] = value;
		}
		_DataMap.put(key, values);
	}

}