/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

package com.ponpo.portal.service.etc;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

import org.gnu.stealthp.rsslib.RSSChannel;
import org.gnu.stealthp.rsslib.RSSException;
import org.gnu.stealthp.rsslib.RSSHandler;
import org.gnu.stealthp.rsslib.RSSItem;
import org.gnu.stealthp.rsslib.RSSParser;

import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortletAction;
import com.ponpo.portal.PortletItem;
import com.ponpo.portal.ValidateError;
import com.ponpo.portal.action.BasePortletAction;
import com.ponpo.taglib.IterateData;
import com.ponpo.taglib.PlainData;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class RssAction extends BasePortletAction implements PortletAction,PlainData,IterateData{
	private RSSHandler _RSSHandler= new RSSHandler();
	private String _Message=null;
	private int _DisplayCnt=0;
	private boolean _DspDetail=false;

	/* ( Javadoc)
	 * @see com.ponpo.portal.action.BasePortletAction#makeDisplayDate(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	protected void makeDisplayDate(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException, ValidateError {
		String rssName=(String)entry.getStrParam("url");
		if(rssName==null){
			_Message="tqkw肵ĉ";
			return;
		}
		String val=entry.getStrParam("dspCnt");
		if(val!=null){
			try {
				_DisplayCnt=Integer.parseInt(val);
			} catch (NumberFormatException e1) {
			}
		}
		val=entry.getStrParam("dspDetail");
		if(val!=null){
			_DspDetail=val.equals("yes");
		}
		
		URL url;
		try {
			url = new URL(rssName);
			RSSParser.parseXmlFile(url,_RSSHandler,false);

		} catch (RSSException e) {
			_Message="tqkF"+rssName+"̃tH[}bg͑ΉĂ܂";
		} catch (MalformedURLException e) {
			_Message="tqkF"+rssName+"sł";
		}
	}
	/* ( Javadoc)
	 * @see com.ponpo.portal.action.BasePortletAction#validate(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	protected void validate(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException, ValidateError {
	}


	/* ( Javadoc)
	 * @see com.ponpo.portal.action.BasePortletAction#doLogic(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	protected void doLogic(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
	}


	/* ( Javadoc)
	 * @see com.ponpo.taglib.PlainData#getTagData(java.lang.String)
	 */
	public String getTagData(HttpServletRequest req,String key) throws JspException {
		RSSChannel channel = _RSSHandler.getRSSChannel();

		if(key.equals("link")){
			return channel.getLink();
		}else if(key.equals("title")){
			return channel.getTitle();
		}else if(key.equals("description")){
			return channel.getDescription();
		}else if(key.equals("copyright")){
			return channel.getCopyright();
		}else if(key.equals("msg")){
			return _Message;
		}
		return "";
	}

	/* ( Javadoc)
	 * @see com.ponpo.taglib.IterateData#getIterator(java.lang.String)
	 */
	public Object getIterator(HttpServletRequest req,String key) throws JspException {
		Collection col = new ArrayList();
		LinkedList lst = _RSSHandler.getRSSChannel().getItems();
		Map map;
		for (int cnt = 0; cnt < lst.size(); cnt++) {
			if(_DisplayCnt>0&&cnt>=_DisplayCnt){
				break;
			}
			RSSItem rSSItem = (RSSItem) lst.get(cnt);
			map=new HashMap();
			map.put("link",rSSItem.getLink());
			map.put("title",rSSItem.getTitle());
			if(_DspDetail){
				map.put("description",rSSItem.getDescription());
			}
			col.add(map);
		}
		return col;

	}
	/* ( Javadoc)
	 * @see com.ponpo.portal.action.BasePortletAction#initExec(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	protected void initExec(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException, ValidateError {
		
	}
}
