/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.service.etc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortletItem;
import com.ponpo.portal.action.EventPortletAction;
import com.ponpo.portal.util.Environment;
import com.ponpo.portal.util.RequestUtils;
import com.ponpo.taglib.PlainData;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class TextEdit extends EventPortletAction implements PlainData{
	protected Map _RequestMap=new HashMap();

	private PortletItem _Entry;
	/* ( Javadoc)
	 * @see com.ponpo.portal.PortletAction#setData(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	public void displayInitDefault(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		Enumeration enum=req.getParameterNames() ;

		while (enum.hasMoreElements()) {
			String key = (String) enum.nextElement() ;
			String value=req.getParameter(key);
			if(value!=null && value.length()>0){
				_RequestMap.put(key,value);
			}
		}
		String actionName = RequestUtils.getActionName(req);
		if (actionName == null) {
			actionName = "upd";
		}
		_RequestMap.put("entryAction", actionName);

		_Entry=entry;
	}
	public void displayExecUpd(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		displayInitDefault(req,res,entry);
	}
	public void logicUpd(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		File makefile=Environment.getRealPath(entry.getStrParam("fileName"));
		try {
			FileOutputStream fout= new FileOutputStream(makefile);
			OutputStreamWriter writer;
			if(entry.getStrParam("encode")!=null){
				writer =new OutputStreamWriter(fout, entry.getStrParam("encode"));
			}else{
				writer =new OutputStreamWriter(fout);
			}

			writer.write((String)_RequestMap.get("data"));
			writer.close();
			fout.close();
		} catch (IOException e) {
			throw new  PortalException(e);
		}
	}
	/* ( Javadoc)
	 * @see com.ponpo.taglib.PlainData#getTagData(java.lang.String)
	 */
	public String getTagData(HttpServletRequest req,String key) throws JspException {
		if(_Entry.getStrParam("fileName")==null){
			return "p[^fileNameKvłB";
		}
		File makefile=Environment.getRealPath(_Entry.getStrParam("fileName"));
		BufferedReader in;
		FileInputStream fis;
		Reader rdr;
		try {
			fis=new FileInputStream(makefile);
			if(_Entry.getStrParam("encode")!=null){
				rdr =new InputStreamReader(fis, _Entry.getStrParam("encode"));
			}else{
				rdr =new InputStreamReader(fis);
			}
			in = new BufferedReader(rdr);
		} catch (FileNotFoundException e) {
			return makefile+"܂";
		} catch (UnsupportedEncodingException e) {
			return _Entry.getStrParam("encode")+"ŃGR[hł܂B";
		}
		String buffer;
		StringBuffer sb=new StringBuffer(); 
		try {
			while((buffer=in.readLine())!=null){
				sb.append(buffer);
				sb.append("\n");
			}
		} catch (IOException e1) {
			throw new JspException(e1);
		}
		try {
			in.close();
			rdr.close();
			fis.close();
		} catch (IOException e2) {
			throw new JspException(e2);
		}
		return sb.toString();
	}
	
	
}
