/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.service.etc;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortletAction;
import com.ponpo.portal.PortletItem;
import com.ponpo.portal.ValidateError;
import com.ponpo.portal.action.BasePortletAction;
import com.ponpo.taglib.PlainData;


public class WebClipAction extends BasePortletAction implements PortletAction,PlainData
{
	
	/* ( Javadoc)
	 * @see com.ponpo.portal.action.BasePortletAction#validate(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	protected void validate(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException, ValidateError {
	}



	/* ( Javadoc)
	 * @see com.ponpo.portal.action.BasePortletAction#doLogic(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	protected void doLogic(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		;
	}
	protected Reader getReader(String url,String inEncoding) throws IOException{
		URL pageUrl = new URL(url);


		URLConnection pageConn = pageUrl.openConnection();

		String encoding=inEncoding;
		if (encoding == null)
		{
			encoding = pageConn.getContentEncoding();
			if (encoding == null)
			{
				encoding = "iso-8859-1";
			}
		}

		/*
		 * Determing if content should be cached.
		 */

		// Assign a reader
		Reader rdr = new InputStreamReader(pageConn.getInputStream(), encoding);

		return rdr;
	}

	private String _Url;
	private String _Encode;
	private String _StartWord;
	private String _EndWord;
	

	/* ( Javadoc)
	 * @see com.ponpo.portal.action.BasePortletAction#makeDisplayDate(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	protected void makeDisplayDate(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException, ValidateError {
		_Url=entry.getStrParam("url");
		_Encode=entry.getStrParam("encode");
		_StartWord=entry.getStrParam("startWord");
		_EndWord=entry.getStrParam("endWord");
	}



	/* ( Javadoc)
	 * @see com.ponpo.taglib.PlainData#getTagData(java.lang.String)
	 */
	public String getTagData(HttpServletRequest req,String key) throws JspException {
		try {
			if(_Url==null){
				return "p[^URLw肵ĉ";
			}

			Reader reader=getReader(_Url,_Encode);
			
			StringBuffer sb = new StringBuffer();
			char buffer[]=new char[1024];
			int len;
			while((len=reader.read(buffer))>0){
				sb.append(buffer,0,len);
			}
			String outBuffer=sb.toString();
			int point;
			if(_StartWord!=null){
				point=outBuffer.indexOf(_StartWord);
				if(point!=-1){
					outBuffer=outBuffer.substring(point);
				}
			}
			if(_EndWord!=null){
				point=outBuffer.indexOf(_EndWord);
				if(point!=-1){
					outBuffer=outBuffer.substring(0,point+_EndWord.length());
				}
			}
			return outBuffer;
		} catch (UnsupportedEncodingException e) {
			return _Encode+"̓T|[gĂȂGR[hłB";
		} catch (MalformedURLException e) {
			return _Url+"݂܂B";
		} catch (FileNotFoundException e) {
			return _Url+"݂܂B";
		} catch (IOException e) {
			throw new JspException(e);
		}
	}



	/* ( Javadoc)
	 * @see com.ponpo.portal.action.BasePortletAction#initExec(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	protected void initExec(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException, ValidateError {	
	}

}
