/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.service.pkg;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

import org.xml.sax.SAXException;

import com.ponpo.portal.ContextManager;
import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortletAction;
import com.ponpo.portal.PortletDefine;
import com.ponpo.portal.PortletItem;
import com.ponpo.portal.PortletManager;
import com.ponpo.portal.PortletStyle;
import com.ponpo.portal.PortletSystemDataUtils;
import com.ponpo.portal.action.EventPortletAction;
import com.ponpo.portal.util.FileUtils;
import com.ponpo.taglib.IterateData;
import com.ponpo.taglib.PlainData;

public class Deployer extends EventPortletAction implements PortletAction,IterateData,PlainData{
	Map _ReadMap=new HashMap();

	/**
	 * \f[^쐬iʏjB<BR>
	 * <PRE>
	 * \f[^쐬܂iʏjB<BR>
	 * </PRE>
	 * @param req@NGXg
	 * @param res@X|X
	 * @param entry@Ă΂ꂽ|[g[g
	 * @throws PortalException@̑O
	 */
	public void displayInitDefault(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		_ReadMap.put("myUrl",PortletSystemDataUtils.getURL(entry));

	}
	public void displayExecDefault(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		displayInitDefault(req,res,entry);
	}

	/**
	 * Adds̓̓`FbNB<BR>
	 * <PRE>
	 * Adds̓̓`FbNs܂B<BR>
	 * </PRE>
	 * @param req@NGXg
	 * @param res@X|X
	 * @param entry@Ă΂ꂽ|[g[g
	 * @throws PortalException@̑O
	 */
	public void validateDefault(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException{

	}


	/**
	 * ǉsB<BR>
	 * <PRE>
	 * ǉs̏s܂B<BR>
	 * </PRE>
	 * @param req@NGXg
	 * @param res@X|X
	 * @param entry@Ă΂ꂽ|[g[g
	 * @throws PortalException@̑O
	 */
	public void logicExec(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		try {
			File deployListPath=PackageManager.getDeployDir();
			File basePath=PackageManager.getAppDir();
			
			String reqPkgIds[]=req.getParameterValues("deployList");
			if(reqPkgIds==null){
				return;
			}
			for (int cnt = 0; cnt < reqPkgIds.length; cnt++) {
				File deployDir=new File(deployListPath,reqPkgIds[cnt]);
				//Ƃރt@Cꗗ擾
				Collection deployFileList=FileUtils.findFiles(deployDir,deployDir.getPath().length());
				PackageDefineData defineData=PackageManager.getPackageDefineData(PackageManager.getDeployDir(),reqPkgIds[cnt]);
				Collection badVersion=PackageManager.checkPackageDepens(defineData.getDepends());
				if(!badVersion.isEmpty()){
					StringBuffer sb=new StringBuffer();
					sb.append(reqPkgIds[cnt]+"͈ˑĂpbP[WȂׁAfvC𒆎~܂.<br>");
					for (Iterator iter= badVersion.iterator(); iter.hasNext();) {
						String msg= (String)iter.next();
						sb.append(msg);
						sb.append("<br>");
					}
					_ValidateError.setMsg(sb.toString());
					return;
				}

				Collection badFileList=PackageManager.checkPackageFileList(reqPkgIds[cnt],deployFileList);
				if(!badFileList.isEmpty()){
					StringBuffer sb=new StringBuffer();
					sb.append(reqPkgIds[cnt]+"͑ŎgpĂt@CׁAfvC𒆎~܂.<br>");
					for (Iterator iter= badFileList.iterator(); iter.hasNext();) {
						String fileName= (String)iter.next();
						sb.append(fileName);
						sb.append("<br>");
					}
					_ValidateError.setMsg(sb.toString());
					return;
				}
				doReadyCopy(deployDir,basePath,defineData.getConfigFile(),deployFileList);
				//Rs[
				FileUtils.treeCopy(deployDir,basePath);
				//pbP[Wt@C̈ړ
				FileUtils.rename(
					new File(deployListPath,reqPkgIds[cnt]+PackageManager.PACKAGE_SUFFIX),
					new File(PackageManager.getPakageInfoDir(),reqPkgIds[cnt]+PackageManager.PACKAGE_SUFFIX)
				);
				//t@Cꗗ̃Zbg
				PackageManager.setPackageFileList(deployFileList,reqPkgIds[cnt]);
				//doResource
				setResource(defineData);
				//^[Qbg̃pbP[W
				FileUtils.treeDel(deployDir);

			}
		} catch (Exception e) {
			throw new PortalException(e);
		}
	}
	private void doReadyCopy(File targetDir,File deployDir,Collection configFiles,Collection copyFiles) throws PortalException{
		for (Iterator iter= copyFiles.iterator(); iter.hasNext();) {
			String fileName= (String)iter.next();
			boolean needCheck=false;
			if(fileName.startsWith("/WEB-INF/lib/")){
				needCheck=true;
			}else if(configFiles.contains(fileName)){
				needCheck=true;
			}
			if(needCheck){
				File targetFile=new File(deployDir,fileName);
				if(targetFile.exists()){
					try {
						FileUtils.treeDel(new File(targetDir,fileName));
					} catch (IOException e) {
						throw new PortalException(e);
					}
				}
			}
		}
	}
	private void setResource(PackageDefineData packageDefineData) throws PortalException{

		if(!packageDefineData.getPortletDefine().isEmpty()){
			PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
			for (Iterator iter = packageDefineData.getPortletDefine().iterator(); iter.hasNext();) {
				PortletDefine item = (PortletDefine) iter.next();
				portletManager.setPortletDefine(item);
			}
			portletManager.savePortletDefine();

		}
		if(!packageDefineData.getPortletStyle().isEmpty()){
			PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
			for (Iterator iter = packageDefineData.getPortletStyle().iterator(); iter.hasNext();) {
				PortletStyle item = (PortletStyle) iter.next();
				portletManager.setPortletStyle(item);
			}
			portletManager.savePortletStyle();
		}
		
	}
	/* ( Javadoc)
	 * @see com.ponpo.taglib.IterateData#getIterator(javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public Object getIterator(HttpServletRequest req, String key) throws JspException {
		File deployDir=PackageManager.getDeployDir();
		Collection col =new ArrayList();
		String fileNames[]=deployDir.list();
		Map map;
		if(fileNames==null ||fileNames.length==0){
		}else{
			for (int cnt = 0; cnt < fileNames.length; cnt++) {
				if(fileNames[cnt].endsWith(PackageManager.PACKAGE_SUFFIX)){
					File targetFile=new File(deployDir.getPath(),fileNames[cnt]);
					PackageDefineData packageDefineData;
					map=new HashMap();
					try {
						ParsePackageDefine parseDefine=new ParsePackageDefine();
						packageDefineData = (PackageDefineData)parseDefine.loadXMLData(targetFile);
				
						map.put("id",packageDefineData.getPkgId());
						map.put("name",packageDefineData.getName());
						map.put("description",packageDefineData.getDescription());
						map.put("version",packageDefineData.getVersion());
					} catch (SAXException e) {
						StringBuffer msg=new StringBuffer();
						msg.append("ERROR FILE=");
						msg.append(targetFile);
						msg.append("\n");
						msg.append(e.getMessage());
						map.put("description",msg.toString());
					} catch (IOException e) {
						StringBuffer msg=new StringBuffer();
						msg.append("ERROR FILE=");
						msg.append(targetFile);
						msg.append("\n");
						msg.append(e.getMessage());
						map.put("description",msg.toString());
					}
					col.add(map);
				}
			}
		}
		return col;

	}

	/* ( Javadoc)
	 * @see com.ponpo.taglib.PlainData#getTagData(javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public String getTagData(HttpServletRequest req, String key) throws JspException {
		return (String)_ReadMap.get(key);
	}
}
