/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.service.pkg;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

import org.apache.commons.fileupload.FileItem;
import org.xml.sax.SAXException;

import com.ponpo.portal.ForwardingURL;
import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortletAction;
import com.ponpo.portal.PortletItem;
import com.ponpo.portal.action.EventPortletAction;
import com.ponpo.portal.util.FileUtils;
import com.ponpo.portal.util.MethodUtils;
import com.ponpo.portal.util.RequestUtils;
import com.ponpo.taglib.IterateData;
import com.ponpo.taglib.PlainData;

public class FileUpLoader extends EventPortletAction implements PortletAction,PlainData,ForwardingURL,IterateData{
	private FileItem _FileItem;
	Map _ReadMap=new HashMap();
	PackageDefineData _PackageDefineData;

	/**
	 * \f[^쐬iʏjB<BR>
	 * <PRE>
	 * \f[^쐬܂iʏjB<BR>
	 * </PRE>
	 * @param req@NGXg
	 * @param res@X|X
	 * @param entry@Ă΂ꂽ|[g[g
	 * @throws PortalException@̑O
	 */
	public void displayExecDefault(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {

		List items=RequestUtils.getMultiRequest(req);
		for (Iterator iter = items.iterator(); iter.hasNext();) {
			FileItem fileItem = (FileItem) iter.next();
			if(fileItem.getFieldName().equals("file")){
				_FileItem=fileItem;
				return;
			}
		}
		_ReadMap.put("haveData","false");
	}

	/**
	 * ǉsB<BR>
	 * <PRE>
	 * ǉs̏s܂B<BR>
	 * </PRE>
	 * @param req@NGXg
	 * @param res@X|X
	 * @param entry@Ă΂ꂽ|[g[g
	 * @throws PortalException@̑O
	 */
	public void logicDefault(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		if(_FileItem.getName()==null||_FileItem.getName().length()==0){
			return ;
		}
		File workDir=PackageManager.getWorkDir();
		File deployListDir=PackageManager.getDeployDir();
		ParsePackageDefine parseDefine=null;
		File deployWorkDir=null;
		try{
			File zipFile=storeHD(workDir);
			deployWorkDir=new File(workDir,req.getSession().getId());
			//WJ
			FileUtils.treeDel(deployWorkDir);
			unzip(deployWorkDir,zipFile);
					
			//pbP[Wǂݍ
			parseDefine=new ParsePackageDefine();
			File packageFile=new File(deployWorkDir,PackageManager.DEPLOY_PACKAGE_FILE);
			_PackageDefineData = (PackageDefineData)parseDefine.loadXMLData(packageFile);

			//pbP[Ẅړ
			File packageIDFile=new File(deployListDir,_PackageDefineData.getPkgId()+PackageManager.PACKAGE_SUFFIX);
			FileUtils.rename(packageFile,packageIDFile);

			//pbP[WfBNgɂ
			File pkgDir=new File(deployListDir,_PackageDefineData.getPkgId());
			FileUtils.rename(deployWorkDir,pkgDir);


			//
			FileUtils.treeDel(zipFile);
			_ReadMap.put("haveData","true");
		}catch(ZipException e){
			_ValidateError.setMsg("Abv[ht@C𓀒ŃG[܂B<br>"+e.getLocalizedMessage());
		}catch(IOException e){
			try {
				FileUtils.treeDel(deployWorkDir);
			} catch (IOException e1) {
				throw new PortalException(e);
			} 
			throw new PortalException(e);
		} catch (SAXException e) {
			Collection col=parseDefine.getErrorMessages();
			StringBuffer sb=new StringBuffer();
			for (Iterator iter = col.iterator(); iter.hasNext();) {
				String errors = (String) iter.next();
				sb.append(errors);
				sb.append("\n");
			}
			_ReadMap.put("SAXException",sb.toString());
			if(deployWorkDir!=null){
				try {
					FileUtils.treeDel(deployWorkDir);
				} catch (IOException e1) {
					throw new PortalException(e);
				} 
			}
		}
	}
	/* ( Javadoc)
	 * @see com.ponpo.taglib.PlainData#getTagData(javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public String getTagData(HttpServletRequest req, String key) throws JspException {
		if(key.equals("haveData")){
			return (String)_ReadMap.get(key);
		}else	if(key.equals("SAXException")){
			return (String)_ReadMap.get(key);
		}else{
			try {
				return (String)MethodUtils.invokeGetter(_PackageDefineData,key);
			} catch (IllegalAccessException e) {
				throw new JspException(e.getCause());
			} catch (InvocationTargetException e) {
				throw new JspException(e.getCause());
			}
		}
	}
	private File storeHD(File workDir) throws IOException{
		File file=new File(_FileItem.getName());
		
		File deployFile;
		if(file.getName().indexOf("\\")>0){
			String fName=file.getName();
			
			deployFile=new File(workDir,fName.substring(fName.lastIndexOf("\\")));
		}else{
			deployFile=new File(workDir,file.getName());
		}

		InputStream ins = _FileItem.getInputStream();
		OutputStream outs = new FileOutputStream(deployFile);
		
		byte buff[]=new byte[256];
		int size;
		while( (size=ins.read(buff) )!=-1){
			outs.write(buff,0,size);
		}
		ins.close();
		outs.close();
		
		return deployFile; 
	}
	private Collection unzip(File baseDir, File file)
		throws ZipException, IOException {
		baseDir.delete();
		//	܂ZipFileIuWFNg쐬܂
		ZipFile zipfile = new ZipFile(file);
		Collection fileList = new ArrayList();


		// zipt@C̊eGg܂
		Enumeration enum = zipfile.entries();
		while (enum.hasMoreElements()) {
			ZipEntry entry = (ZipEntry) enum.nextElement();


			String entryName = entry.getName();
	
			File outputfile = new File(baseDir, entryName);
			if(entry.isDirectory()){
				if(!outputfile.mkdirs()){
					throw new IOException("Can't not make dir:"+outputfile);
				}
			}else{
				outputfile.getParentFile().mkdirs();
				FileOutputStream out = new FileOutputStream(outputfile);
				fileList.add(outputfile.getPath());
				InputStream in = zipfile.getInputStream(entry);
				if(in !=null){
					byte[] buffer = new byte[512];
					int size = 0;
					while ((size = in.read(buffer)) > 0) {
						out.write(buffer, 0, size);
					}
					in.close();
				}
				// Xg[܂
				out.close();
			}
		}
		zipfile.close();
		return fileList;
	}

	/* ( Javadoc)
	 * @see com.ponpo.portal.ForwardingURL#getFrowardURLWhenExec(javax.servlet.http.HttpServletRequest)
	 */
	public String getFrowardURLWhenExec(HttpServletRequest req) {
		return null;
	}

	/* ( Javadoc)
	 * @see com.ponpo.taglib.IterateData#getIterator(javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public Object getIterator(HttpServletRequest req, String key) throws JspException {
		try {
			return MethodUtils.invokeGetter(_PackageDefineData,key);
		} catch (IllegalAccessException e) {
			throw new JspException(e.getCause());
		} catch (InvocationTargetException e) {
			throw new JspException(e.getCause());
		}
	}
}
