/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.service.pkg;

import java.util.ArrayList;
import java.util.Collection;

import com.ponpo.portal.PortletDefine;
import com.ponpo.portal.PortletStyle;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class PackageDefineData {
	private String _PkgId;
	private String _Name;
	private String _Description;
	private String _Author;
	private String _EMail;
	private String _Url;
	private String _License;
	private String _VersionMejor;
	private String _VersionMinor;
	private String _VersionRevision;
	private String _InstallNote;
	private String _UninstallNote;
	private Collection _History=new ArrayList();
	private Collection _Depends=new ArrayList();
	private Collection _ConfigFile=new ArrayList();
	private Collection _PortletDefine=new ArrayList();
	private Collection _PortletStyle=new ArrayList();
	public void add(Object obj){
		if(obj instanceof PortletDefine){
			_PortletDefine.add(obj);
		}else if(obj instanceof PortletStyle){
			_PortletStyle.add(obj);
		}
	}
	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @return
	 */
	public String getAuthor() {
		return _Author;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @return
	 */
	public String getDescription() {
		return _Description;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @return
	 */
	public String getEMail() {
		return _EMail;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @return
	 */
	public String getPkgId() {
		return _PkgId;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @return
	 */
	public String getLicense() {
		return _License;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @return
	 */
	public String getName() {
		return _Name;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @return
	 */
	public String getUrl() {
		return _Url;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @param string
	 */
	public void setAuthor(String string) {
		_Author = string;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @param string
	 */
	public void setDescription(String string) {
		_Description = string;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @param string
	 */
	public void setEMail(String string) {
		_EMail = string;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @param string
	 */
	public void setPkgId(String string) {
		_PkgId = string;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @param string
	 */
	public void setLicense(String string) {
		_License = string;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @param string
	 */
	public void setName(String string) {
		_Name = string;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @param string
	 */
	public void setUrl(String string) {
		_Url = string;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @return
	 */
	public Collection getHistory() {
		return _History;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @return
	 */
	public String getInstallNote() {
		return _InstallNote;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @return
	 */
	public Collection getPortletDefine() {
		return _PortletDefine;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @return
	 */
	public String getUninstallNote() {
		return _UninstallNote;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @return
	 */
	public String getVersionMejor() {
		return _VersionMejor;
	}

	public String getVersion() {
		return _VersionMejor+"-"+_VersionMinor+"."+_VersionRevision;
	}
	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @return
	 */
	public String getVersionMinor() {
		return _VersionMinor;
	}

	public String getVersionRevision() {
		return _VersionRevision;
	}

	public void setHistory(String val) {
		_History.add(val);
	}

	public void setInstallNote(String string) {
		_InstallNote = string;
	}

	public void setPortletDefine(Collection collection) {
		_PortletDefine = collection;
	}

	public void setUninstallNote(String string) {
		_UninstallNote = string;
	}

	public void setVersionMejor(String string) {
		_VersionMejor = string;
	}

	public void setVersionMinor(String string) {
		_VersionMinor = string;
	}

	public void setVersionRevision(String string) {
		_VersionRevision = string;
	}

	public Collection getPortletStyle() {
		return _PortletStyle;
	}

	public Collection getConfigFile() {
		return _ConfigFile;
	}

	public void setConfigFile(String val) {
		_ConfigFile.add(val);
	}
	public Collection getDepends() {
		return _Depends;
	}

	public void setDepends(Object versionInfo) {
		_Depends.add(versionInfo);
	}

}	

