/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.service.pkg;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

import org.xml.sax.SAXException;

import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortletAction;
import com.ponpo.portal.PortletItem;
import com.ponpo.portal.PortletSystemDataUtils;
import com.ponpo.portal.action.EventPortletAction;
import com.ponpo.portal.util.FileUtils;
import com.ponpo.portal.util.MethodUtils;
import com.ponpo.taglib.IterateData;
import com.ponpo.taglib.PlainData;

public class PackageInfor extends EventPortletAction implements PortletAction,PlainData,IterateData{
	private Map _ReadMap=new HashMap();
	private PackageDefineData _PackageDefineData;
	private String _PkgId;
	private String _Kind;

	/**
	 * \f[^쐬iʏjB<BR>
	 * <PRE>
	 * \f[^쐬܂iʏjB<BR>
	 * </PRE>
	 * @param req@NGXg
	 * @param res@X|X
	 * @param entry@Ă΂ꂽ|[g[g
	 * @throws PortalException@̑O
	 */
	public void displayInitDefault(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		_Kind=entry.getStrParam("kind");
		_PkgId=req.getParameter("id");
		String pkgFile;
		if(_Kind.equals("pkg")){
			pkgFile=PackageManager.getPakageInfoDir()+"/"+_PkgId+".xml";
		}else{
			pkgFile=PackageManager.getDeployDir()+"/"+_PkgId+".xml";
		}

		ParsePackageDefine parseDefine=null;
		try{
			//pbP[Wǂݍ
			parseDefine=new ParsePackageDefine();
			_PackageDefineData = (PackageDefineData)parseDefine.loadXMLData(new File(pkgFile));

		}catch(IOException e){
			throw new PortalException(e);
		} catch (SAXException e) {
			Collection col=parseDefine.getErrorMessages();
			StringBuffer sb=new StringBuffer();
			for (Iterator iter = col.iterator(); iter.hasNext();) {
				String errors = (String) iter.next();
				sb.append(errors);
				sb.append("\n");
			}
			_ReadMap.put("SAXException",sb.toString());
		}
		_ReadMap.put("myUrl",PortletSystemDataUtils.getURL(entry));
	}

	/* ( Javadoc)
	 * @see com.ponpo.taglib.PlainData#getTagData(javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public String getTagData(HttpServletRequest req, String key) throws JspException {
		if(key.equals("haveData")){
			return (String)_ReadMap.get(key);
		}else	if(key.equals("SAXException")){
			return (String)_ReadMap.get(key);
		}else{
			try {
				return (String)MethodUtils.invokeGetter(_PackageDefineData,key);
			} catch (IllegalAccessException e) {
				throw new JspException(e.getCause());
			} catch (InvocationTargetException e) {
				throw new JspException(e.getCause());
			}
		}
	}
	/* ( Javadoc)
	 * @see com.ponpo.taglib.IterateData#getIterator(javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public Object getIterator(HttpServletRequest req, String key) throws JspException {
		if(key.equals("fileList")){
			try {
				if(_Kind.equals("pkg")){
					return PackageManager.getPackageFileList(_PkgId);
				}else{
					File deployDir=new File(PackageManager.getDeployDir(),_PkgId);
					return FileUtils.findFiles(deployDir,deployDir.getPath().length());

				}
			} catch (PortalException e) {
				throw new JspException(e);
			} catch (IOException e) {
				throw new JspException(e);
			}
		}else{
			try {
				return MethodUtils.invokeGetter(_PackageDefineData,key);
			} catch (IllegalAccessException e) {
				throw new JspException(e.getCause());
			} catch (InvocationTargetException e) {
				throw new JspException(e.getCause());
			}
		}
	}
}
