/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.service.pkg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;

import org.xml.sax.SAXException;

import com.ponpo.portal.PortalException;
import com.ponpo.portal.util.Environment;
import com.ponpo.portal.util.FileUtils;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class PackageManager {
	public static String DEPLOY_PACKAGE_FILE="package.xml";
	public static String PACKAGE_SUFFIX=".xml";
	public static String PACKAGE_LIST_SUFFIX=".lst";
	

	private synchronized  static List removePackageFileList(Properties prop,String pkgId) throws PortalException{
		List col=new ArrayList();
		Enumeration enum=prop.keys();
		while (enum.hasMoreElements()) {
			String fileName = (String) enum.nextElement();
			if(pkgId.equals(prop.getProperty(fileName))){
				prop.remove(fileName);
				col.add(fileName);
			}
		}
		return col;
	}
	public synchronized  static Collection getPackageFileList( String pkgId) throws PortalException{
		Collection col=new TreeSet();
		try{
			Properties prop=loadPackageFileList();
			Enumeration enum=prop.keys();
			while (enum.hasMoreElements()) {
				String fileName = (String) enum.nextElement();
				if(pkgId.equals(prop.getProperty(fileName))){
					col.add(fileName);
				}
			}
		}catch(IOException e){
			throw new PortalException(e);
		}
		return col;
	}
	public static Collection checkPackageDepens(Collection depens) throws PortalException{
		Collection col=new TreeSet();
		try{
			for (Iterator iter= depens.iterator(); iter.hasNext();) {
				VersionInfo versionInfo= (VersionInfo)iter.next();
				PackageDefineData defineData;
				try {
					defineData= getPackageDefineData(PackageManager.getPakageInfoDir(),versionInfo.getPkgId());
				} catch (FileNotFoundException e1) {
					col.add(versionInfo.getPkgId()+"("+versionInfo.getMejor()+"-"+versionInfo.getMejor()+")");
					continue;
				}

				boolean compare=true;
				int mejorCompare=defineData.getVersionMejor().compareTo(versionInfo.getMejor());
				if( mejorCompare>0 ){
					compare=false;
				}else if(mejorCompare==0){
					if(defineData.getVersionMinor().compareTo(versionInfo.getMinor())>=0){
						compare=false;
					}
				}
				if(compare){
					col.add(versionInfo.getPkgId()+"("+versionInfo.getMejor()+"-"+versionInfo.getMejor()+")");
				}
			}
		}catch(IOException e){
			throw new PortalException(e);
		} catch (SAXException e) {
			throw new PortalException(e);
		}
		return col;
	}
	public static Collection checkPackageFileList(String pkgId,Collection fileList) throws PortalException{
		Collection col=new TreeSet();
		try{
			Properties prop=loadPackageFileList();
			for (Iterator iter= fileList.iterator(); iter.hasNext();) {
				String fileName= (String)iter.next();
				String propId=prop.getProperty(fileName,pkgId);
				if(!propId.equals(pkgId)){
					col.add(fileName+"("+propId+")");
				}
			}
		}catch(IOException e){
			throw new PortalException(e);
		}
		return col;
	}
	public synchronized  static Collection setPackageFileList(Collection col,String pkgId) throws PortalException{
		try{
			Collection badFileList=new TreeSet();
			Properties prop=loadPackageFileList();
			File appDir=getAppDir();
			List oldFileList=removePackageFileList(prop,pkgId);

			for (Iterator iter = col.iterator(); iter.hasNext();) {
				String fileName = (String) iter.next();
				oldFileList.remove(fileName);
				prop.setProperty(fileName,pkgId);
			}

			savePackageFileList(prop);
			for (Iterator iter= oldFileList.iterator(); iter.hasNext();) {
				String fileName= (String)iter.next();
				File file=new File(appDir,fileName);
				try {
					FileUtils.treeDel(file);
				}catch(IOException e){
					badFileList.add(fileName);					
				}
			}
			return badFileList;
		}catch(IOException e){
			throw new PortalException(e);
		}
	}
	private  static Properties loadPackageFileList() throws IOException{
		Properties prop=new Properties();
		FileInputStream fiStream=new FileInputStream(getPakageListFile());
		prop.load(fiStream );
		fiStream.close();
		return prop;
	}
	private static void  savePackageFileList(Properties prop) throws IOException{
		FileOutputStream foStream=new FileOutputStream(getPakageListFile());;
		prop.save(foStream,"File List");
		foStream.close();
	}
	public static File getPakageListFile(){
		return new File(getPakageInfoDir(),"pakageFileList.prop");
	}
	public static File getPakageInfoDir(){
		return Environment.getRealPath("/WEB-INF/deploy/packageInfo");
	}
	public static File getWorkDir(){
		return Environment.getRealPath("/WEB-INF/deploy/work");
	}
	public static File getDeployDir(){
		return Environment.getRealPath("WEB-INF/deploy/deployList/");
	}
	public static File getAppDir(){
//		return Environment.getRealPath("/WEB-INF/deploy/TEST/");
		return Environment.getRealPath("/");
	}
	public static PackageDefineData getPackageDefineData(File dir,String pkgId) throws SAXException, IOException{
		File pkgFile=new File(dir,pkgId+PackageManager.PACKAGE_SUFFIX);
		ParsePackageDefine parseDefine=new ParsePackageDefine();
		return (PackageDefineData)parseDefine.loadXMLData(pkgFile);
	}
}
