/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.service.pkg;

import com.ponpo.parse.xml.BaseDigester;
import com.ponpo.portal.impl.file.ParseBase;
import com.ponpo.portal.impl.file.ParsePortletDefine;
import com.ponpo.portal.impl.file.ParsePortletStyle;




/**
 * PortalXMĹB<BR>
 * <UL>
 * Portal̉͂s܂B<BR>
 * </UL>
 * @since 1.0.0
 * @version 1.00.00
 * @author Yoshi Sasaki
 */
public class ParsePackageDefine extends ParseBase{


	PackageDefineData _PackageDefineData;
	public void add(Object obj){
		_PackageDefineData=(PackageDefineData)obj;	
	}


	/* ( Javadoc)
	 * @see com.ponpo.portal.parse.ParseBase#getReturnData()
	 */
	protected Object getReturnData() {
		return _PackageDefineData;
	}

	/* ( Javadoc)
	 * @see com.ponpo.portal.parse.ParseBase#setDetailRule(com.ponpo.portal.parse.BaseDigester)
	 */
	protected void setDetailRule(BaseDigester digester) {
		digester.addObjectCreate("*/packageDefine", PackageDefineData.class.getName());
		digester.addSetProperties("*/packageDefine");
		digester.addCallMethod("*/pkgId", "setPkgId", 0);
		digester.addCallMethod("*/name", "setName", 0);
		digester.addCallMethod("*/description", "setDescription", 0);
		digester.addCallMethod("*/author", "setAuthor", 0);
		digester.addCallMethod("*/eMail", "setEMail", 0);
		digester.addCallMethod("*/url", "setUrl", 0);
		digester.addCallMethod("*/license", "setLicense", 0);
		digester.addCallMethod("*/version/mejor", "setVersionMejor", 0);
		digester.addCallMethod("*/version/minor", "setVersionMinor", 0);
		digester.addCallMethod("*/version/revision", "setVersionRevision", 0);
		digester.addCallMethod("*/history", "setHistory", 0);
		digester.addCallMethod("*/configFile", "setConfigFile", 0);
		digester.addCallMethod("*/installNote", "setInstallNote", 0);
		digester.addCallMethod("*/uninstallNote", "setUninstallNote", 0);
		digester.addSetNext("*/packageDefine", "add");

		digester.addObjectCreate("*/depends", VersionInfo.class.getName());
		digester.addSetProperties("*/depends");
		digester.addSetNext("*/depends", "setDepends");


		ParsePortletDefine parsePortletDefine=new ParsePortletDefine();
		parsePortletDefine.setDetailRule(digester);

		ParsePortletStyle parsePortletStyle=new ParsePortletStyle();
		parsePortletStyle.setDetailRule(digester);
		
	}

}
