/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.service.portal.entry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

import com.ponpo.portal.ContextManager;
import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortletAction;
import com.ponpo.portal.PortletItem;
import com.ponpo.portal.PortletManager;
import com.ponpo.portal.UserManager;
import com.ponpo.portal.action.EventPortletAction;
import com.ponpo.portal.util.RequestUtils;
import com.ponpo.portal.util.Validator;
import com.ponpo.taglib.IterateData;
import com.ponpo.taglib.OptionData;
import com.ponpo.taglib.OptionDataImpl;
import com.ponpo.taglib.PlainData;
import com.ponpo.taglib.SelectData;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class PortalEntry extends EventPortletAction implements  PortletAction,PlainData,IterateData,SelectData{

	private Map _RequestDat=new HashMap();

	Collection _UserPortal=new ArrayList();
	Collection _AllPortal=new ArrayList();


	/**
	 * \f[^쐬iʏjB<BR>
	 * <PRE>
	 * \f[^쐬܂iʏjB<BR>
	 * </PRE>
	 * @param req@NGXg
	 * @param res@X|X
	 * @param entry@Ă΂ꂽ|[g[g
	 * @throws PortalException@̑O
	 */
	public void displayInitDefault(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		Enumeration enum=req.getParameterNames() ;

		while (enum.hasMoreElements()) {
			String key = (String) enum.nextElement() ;
			String value=req.getParameter(key);
			if(value!=null && value.length()>0){
				_RequestDat.put(key,value);
			}
		}
		String actionName = RequestUtils.getActionName(req);
		if (actionName == null) {
			actionName = "none";
		}
		_RequestDat.put("entryAction", actionName);

	}
	public void displayInitAdd(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		displayInitDefault(req,res,entry);
		PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
		for (Iterator iter = portletManager.getPortalKeys(); iter.hasNext();) {
			String keyEntry = (String) iter.next();
			_AllPortal.add(keyEntry);
		}
	}
	public void displayInitDel(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		displayInitAdd(req,res,entry);
	}
	/**
	 * \f[^쐬iXVjB<BR>
	 * <PRE>
	 * \f[^쐬܂iXVjB<BR>
	 * </PRE>
	 * @param req@NGXg
	 * @param res@X|X
	 * @param entry@Ă΂ꂽ|[g[g
	 * @throws PortalException@̑O
	 */
	public void displayInitUpd(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		displayInitDefault(req,res,entry);

		
		PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
		UserManager userManager=(UserManager)ContextManager.lookupImplementer("com.ponpo.portal.UserManager");

		Iterator iterator=userManager.getEnablePortals((String)_RequestDat.get("uid"));
		StringBuffer userPortalList=new StringBuffer();
		while (iterator.hasNext()) {
			String val=(String)iterator.next();
			_UserPortal.add(val);
			userPortalList.append(val);
			userPortalList.append(",");
		}
		_RequestDat.put("userPortalList", userPortalList.toString());

		for (Iterator iter = portletManager.getPortalKeys(); iter.hasNext();) {
			String keyEntry = (String) iter.next();
			if(!_UserPortal.contains(keyEntry)){
				_AllPortal.add(keyEntry);
			}
		}

	}
	public void displayExecUpd(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		displayInitDefault(req,res,entry);
	}
	public void displayExecAdd(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		displayInitAdd(req,res,entry);
	}
	public void displayExecDel(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		displayInitAdd(req,res,entry);
	}
	public void validateAdd(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException{

		String value;

		value=(String)_RequestDat.get("allPortal");
		if(Validator.checkEmpty(value)){
			_ValidateError.setMsg("x[XƂ|[gbg͕K{͂łB");	
		}
		value=(String)_RequestDat.get("portalName");
		if(Validator.checkEmpty(value)){
			_ValidateError.setMsg("|[^Ƃ|[gbg͕K{͂łB");	
		}
		
	}
	public void validateDel(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException{

		String value;
		value=(String)_RequestDat.get("allPortal");
		if(Validator.checkEmpty(value)){
			_ValidateError.setMsg("폜|[gbg͕K{͂łB");	
		}else if(value.equals("guest")){
			_ValidateError.setMsg("guest͍폜o܂B");	
		}
		
	}

	public void logicAdd(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
		portletManager.copyPortal((String)_RequestDat.get("allPortal"),(String)_RequestDat.get("portalName"));
	}
	public void logicUpd(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		UserManager userManager=(UserManager)ContextManager.lookupImplementer("com.ponpo.portal.UserManager");
		userManager.setPortal((String)_RequestDat.get("uid"),(String)_RequestDat.get("userPortalList"));
	}
	public void logicDel(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
		portletManager.removePortal((String)_RequestDat.get("allPortal"));
		UserManager userManager=(UserManager)ContextManager.lookupImplementer("com.ponpo.portal.UserManager");
		userManager.removePortal((String)_RequestDat.get("allPortal"));
	}

	/* ( Javadoc)
	 * @see com.ponpo.taglib.PlainData#getTagData(java.lang.String)
	 */
	public String getTagData(HttpServletRequest req,String key) throws JspException {
		return (String)_RequestDat.get(key);
	}

	/* ( Javadoc)
	 * @see com.ponpo.taglib.IterateData#getIterator(java.lang.String)
	 */
	public Object getIterator(HttpServletRequest req,String key) throws JspException {
		Collection col=new ArrayList();
		try{
			UserManager userManager=(UserManager)ContextManager.lookupImplementer("com.ponpo.portal.UserManager");
			for (Iterator iter = userManager.getUsers(); iter.hasNext();) {
				String userName = (String) iter.next();
				Map map=new HashMap();
				col.add(map);
				map.put("userName",userName);
				Iterator iterator=userManager.getEnablePortals(userName);
				StringBuffer portalNames=new StringBuffer();
				while (iterator.hasNext()) {
					portalNames.append(iterator.next());
					portalNames.append(",");
				}
				map.put("portals",portalNames.toString());
				
			}
			
		}catch(PortalException e){
			throw new JspException(e.getCause());
		}
		return col;
	}


	/* ( Javadoc)
	 * @see com.ponpo.taglib.SelectData#getOptions(java.lang.String)
	 */
	public OptionData[] getOptions(HttpServletRequest req,String key) throws JspException {
		Iterator iterator;
		if(key.equals("allPortal")){
			iterator=_AllPortal.iterator();
		}else{
			iterator=_UserPortal.iterator();
		}
		Collection col=new ArrayList();
		while (iterator.hasNext()) {
			String element = (String) iterator.next();
			col.add(new OptionDataImpl(element,element));
		}
		return (OptionDataImpl[])col.toArray(new OptionDataImpl[0]);

	}
	/* ( Javadoc)
	 * @see com.ponpo.taglib.SelectData#getSelectValue(javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public String getSelectValue(HttpServletRequest req, String key) throws JspException {
		return (String)_RequestDat.get(key);
	}

}
