/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.service.portlet.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

import com.ponpo.portal.ContextManager;
import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortalUtils;
import com.ponpo.portal.PortletAction;
import com.ponpo.portal.PortletDefine;
import com.ponpo.portal.PortletItem;
import com.ponpo.portal.PortletManager;
import com.ponpo.portal.PortletParam;
import com.ponpo.portal.PortletSystemDataUtils;
import com.ponpo.portal.SecurityManager;
import com.ponpo.portal.UserManager;
import com.ponpo.portal.action.EventPortletAction;
import com.ponpo.portal.skin.PortletEditOption;
import com.ponpo.portal.skin.PortletEditText;
import com.ponpo.portal.util.MapComparator;
import com.ponpo.portal.util.RequestUtils;
import com.ponpo.portal.util.Validator;
import com.ponpo.taglib.Filter;
import com.ponpo.taglib.IterateData;
import com.ponpo.taglib.OptionData;
import com.ponpo.taglib.OptionData4Const;
import com.ponpo.taglib.OptionDataImpl;
import com.ponpo.taglib.PlainData;
import com.ponpo.taglib.SelectData;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class PortletEdit extends EventPortletAction implements  PortletAction,PlainData,IterateData,SelectData{

	private PortletItem _EditPortletItem;
	private Map _RequestDat=new HashMap();
	private String _CurrentPath;
	private HttpServletRequest _ServletRequest;
	private HttpServletResponse _ServletResponse;
	/**
	 * \f[^쐬iʏjB<BR>
	 * <PRE>
	 * \f[^쐬܂iʏjB<BR>
	 * </PRE>
	 * @param req@NGXg
	 * @param res@X|X
	 * @param entry@Ă΂ꂽ|[g[g
	 * @throws PortalException@̑O
	 */
	public void displayInitDefault(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		_ServletRequest=req;
		_ServletResponse=res;
		Enumeration enum=req.getParameterNames() ;

		while (enum.hasMoreElements()) {
			String key = (String) enum.nextElement() ;
			String value=req.getParameter(key);
			if(value!=null && value.length()>0){
				_RequestDat.put(key,value);
			}
		}
		UserManager userManager=(UserManager)ContextManager.lookupImplementer("com.ponpo.portal.UserManager");

		String portalName=userManager.getStartPortal(req.getRemoteUser());

		PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
		PortletItem topItem=portletManager.getPortal(portalName);
		String path=req.getPathInfo().substring(0,req.getPathInfo().length()-"/portlet_edit".length());

		_EditPortletItem=PortalUtils.lookupPortalItem(topItem,path);
		String actionName = RequestUtils.getActionName(req);
		if (actionName == null) {
			actionName = "add";
		}
		_RequestDat.put("entryAction", actionName);
		_RequestDat.put("myPortletName", getPortletName(portletManager,entry.getPortletName()));
		_RequestDat.put("myURL",PortletSystemDataUtils.getURL(entry));
		_RequestDat.put("mylabel", entry.getLabel());
		_RequestDat.put("myReadRole", entry.getReadRole());
		_RequestDat.put("myEditRole", entry.getEditRole());
		

		_CurrentPath=RequestUtils.getCurrentUrlPath(req);

	}
	public void displayExecDefault(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		displayInitDefault(req,res,entry);
	}
	/**
	 * \f[^쐬iXVjB<BR>
	 * <PRE>
	 * \f[^쐬܂iXVjB<BR>
	 * </PRE>
	 * @param req@NGXg
	 * @param res@X|X
	 * @param entry@Ă΂ꂽ|[g[g
	 * @throws PortalException@̑O
	 */
	public void displayInitUpd(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		displayInitDefault(req,res,entry);

		PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
		if(_RequestDat.get("type").equals("param")){
			String name=req.getParameter("id");
			PortletDefine defineItem=portletManager.getPortletDefine(entry.getPortletName());
			if(defineItem!=null){
				if(name.equals("style")){
					_RequestDat.put("isDef","true");
					_RequestDat.put("label","X^C");
					_RequestDat.put("name",name);
					_RequestDat.put("discription","|[gbgEX^CIŉB");

					_RequestDat.put("value",typeSelect(req,name,entry.getPortletParam(name),PortletEditOptionStyle.class.getName()));
						
				}else {
					PortletParam portletParam=defineItem.getPortletParam(name);
					if(portletParam!=null){
						String label=portletParam.getParam("label");
						String inputType=portletParam.getParam("inputType");
						String discription=portletParam.getParam("discription");
						String other=portletParam.getParam("other");
						if(label==null){
							label=name;
						}
						_RequestDat.put("isDef","true");
						_RequestDat.put("label",label);
						_RequestDat.put("name",name);
						_RequestDat.put("discription",discription);
					
						if(inputType==null || inputType.equals("text")){
							_RequestDat.put("value",typeText(entry.getPortletParam(name )));
						}else	if( inputType.equals("radio")){
							_RequestDat.put("value",typeRadio(req,name,entry.getPortletParam(name),other));
						}else	if( inputType.equals("select")){
							_RequestDat.put("value",typeSelect(req,name,entry.getPortletParam(name),other));
						}else	if( inputType.equals("check")){
							_RequestDat.put("value",typeCheck(entry.getPortletParam(name),other));
						}else	if( inputType.equals("other")){
							_RequestDat.put("value",typeOther(req,name,entry.getPortletParam(name),other));
						}else{
							_RequestDat.put("value",entry.getPortletParam(name ));
						}
					}
				}
			}else{
				_RequestDat.put("label",name);
				_RequestDat.put("name",name);
				_RequestDat.put("value",entry.getPortletParam(name ));
			}
			
			
			
		}else{
			String name=req.getParameter("id");
			PortletItem leafItem;
			if(name!=null){
				leafItem=getLeafItem(_EditPortletItem.getLeaf(),name);
			}else{
				leafItem=_EditPortletItem;
			}
			if(leafItem!=null){
				_RequestDat.put("portletName",leafItem.getPortletName());
				_RequestDat.put("newId",leafItem.getId());
				_RequestDat.put("label",leafItem.getLabel());
				_RequestDat.put("readRole",leafItem.getReadRole());
				_RequestDat.put("editRole",leafItem.getEditRole());
			}
		}
	}
	public void displayInitDel(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		displayInitUpd(req,res,entry);
	}
	/**
	 * ǉs̓̓`FbNB<BR>
	 * <PRE>
	 * ǉs̓̓`FbNs܂B<BR>
	 * </PRE>
	 * @param req@NGXg
	 * @param res@X|X
	 * @param entry@Ă΂ꂽ|[g[g
	 * @throws PortalException@̑O
	 */
	public void validateAdd(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException{

		String value;

		value=(String)_RequestDat.get("newId");
		if(Validator.checkEmpty(value)){
			_ValidateError.setMsg("hc͕K{ł");	
		}else{
			if(Validator.checkNotAlphanumericPlus(value,"\\.\\-_~")){
				_ValidateError.setMsg("hc͉p(._-~܂)ł");	
			}else{
				int pos=value.indexOf(".");
				if(pos==0){
					_ValidateError.setMsg(".͐擪Ɏwł܂");	
				}
			}
		}
		value=(String)_RequestDat.get("portletName");
		if(Validator.checkEmpty(value)){
			_ValidateError.setMsg("|[g[g͕K{ł");	
		}
		
	}
	public void validateUpd(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException{
		if(_RequestDat.get("type").equals("param")){
		}else{
			validateAdd(req,res,entry);
		}
	}
	/* ( Javadoc)
	 * @see com.ponpo.portal.PortletAction#logic(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	public void logicAdd(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
		PortletItem item=portletManager.newPortletItem();
		try {
			item.setId((String)_RequestDat.get("newId"));
			item.setPortletName((String)_RequestDat.get("portletName"));
			item.setLabel((String)_RequestDat.get("label"));
			item.setReadRole((String)_RequestDat.get("readRole"));
			item.setEditRole((String)_RequestDat.get("editRole"));

			PortletDefine defineItem=portletManager.getPortletDefine((String)_RequestDat.get("portletName"));			
			
			for (Iterator iter = defineItem.getPortletParamKeys(); iter.hasNext();) {
				String keyEntry = (String) iter.next();
				item.addPortletParam(keyEntry,defineItem.getPortletParam(keyEntry).getValue());
			}
			
		} catch (Exception e) {
			throw new PortalException(e);
		}
		_EditPortletItem.getLeaf().add(item);
		save(req);
	}

	/* ( Javadoc)
	 * @see com.ponpo.portal.PortletAction#logic(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	public void logicDel(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {

		String name=req.getParameter("id");
		PortletItem leafItem=(PortletItem)getLeafItem(_EditPortletItem.getLeaf(),name);
		if(leafItem!=null){
			_EditPortletItem.getLeaf().remove(leafItem);
			save(req);
		}
	}
	public void logicUpd(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		if(_RequestDat.get("type").equals("param")){
			_EditPortletItem.addPortletParam((String)_RequestDat.get("name"),(String)_RequestDat.get("value"));
			save(req);
		}else{
			String id=req.getParameter("id");
			PortletItem leafItem;
			if(id!=null&& id.length()>0){
				leafItem=(PortletItem)getLeafItem(_EditPortletItem.getLeaf(),id);
			}else{
				leafItem=(PortletItem)_EditPortletItem;
			}
			if(leafItem!=null){
				leafItem.setPortletName((String)_RequestDat.get("portletName"));
				leafItem.setId((String)_RequestDat.get("newId"));
				leafItem.setLabel((String)_RequestDat.get("label"));
				leafItem.setReadRole((String)_RequestDat.get("readRole"));
				leafItem.setEditRole((String)_RequestDat.get("editRole"));
				save(req);
			}
		}
	}
	public void logicSync(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		doSync(entry);
		save(req);
	}
	private void doSync(PortletItem entry){
		PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
		PortletDefine defineItem=portletManager.getPortletDefine(entry.getPortletName());
		if(defineItem!=null){
			Map map=new HashMap();	
			for (Iterator iter = defineItem.getPortletParamKeys(); iter.hasNext();) {
				String keyEntry = (String) iter.next();
				map.put(keyEntry,"");
				if(entry.getPortletParam(keyEntry)==null){
					entry.addPortletParam(keyEntry,defineItem.getPortletParam(keyEntry).getValue());
				}
			}
			PortletItem item=(PortletItem)entry;
			boolean flag;
			do {
				flag=false;
				for (Iterator iter = item.getPortletParamKeys(); iter.hasNext();) {
					String keyEntry = (String) iter.next();
					if(!map.containsKey(keyEntry)){
						item.removePortletParam(keyEntry);
						flag=true;
						break;
					}
				}
				
			} while (flag);
		}
		
	}
	public void logicUp(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		PortletItem moveItem=getLeafItem(_EditPortletItem.getLeaf(),(String)_RequestDat.get("id"));
		List list=(List)_EditPortletItem.getLeaf();
		int pos=list.indexOf(moveItem);
		pos--;
		if(pos>=0 ){
			list.remove(moveItem);
			list.add(pos,moveItem );
			save(req);
		}
		
	}
	public void logicDown(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		PortletItem moveItem=getLeafItem(_EditPortletItem.getLeaf(),(String)_RequestDat.get("id"));
		List list=(List)_EditPortletItem.getLeaf();
		int pos=list.indexOf(moveItem);
		pos++;
		if(pos<list.size() ){
			list.remove(moveItem);
			list.add(pos,moveItem );
			save(req);
		}
	}

	/* ( Javadoc)
	 * @see com.ponpo.taglib.PlainData#getTagData(java.lang.String)
	 */
	public String getTagData(HttpServletRequest req,String key) throws JspException {
		return (String)_RequestDat.get(key);
	}


	private Collection _PortletDefinesCol;
	/* ( Javadoc)
	 * @see com.ponpo.taglib.IterateData#getIterator(java.lang.String)
	 */
	private String getPortletName(PortletManager portletManager,String portletName){
		PortletDefine defineItem=portletManager.getPortletDefine(portletName);
		if(defineItem==null){
			return portletName;
		}else{
			return(defineItem.getPortletName());
		}
		
	}
	public Object getIterator(HttpServletRequest req,String key) throws JspException {
		Collection col=new ArrayList();
		if(_EditPortletItem != null){
			if(key.equals("portlet")){
				SecurityManager securityManager=(SecurityManager)ContextManager.lookupImplementer("com.ponpo.portal.SecurityManager");
				PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");

				for (Iterator iter = _EditPortletItem.getLeaf().iterator(); iter.hasNext();) {
					PortletItem leafItem = (PortletItem) iter.next();
					if(securityManager.isReadEnabled(_ServletRequest,_ServletResponse,leafItem)){
						Map map=new HashMap();
						map.put("portletNameLabel",getPortletName(portletManager,leafItem.getPortletName()));
						map.put("id",leafItem.getId());
						map.put("label",leafItem.getLabel());
						map.put("readRole",leafItem.getReadRole());
						map.put("editRole",leafItem.getEditRole());
						map.put("isEditEnabled",securityManager.isEditEnabled(_ServletRequest,_ServletResponse,leafItem)?"true":"false");
						col.add(map);
					}
				}
			}else if(key.equals("portletDefine")){
				if(_PortletDefinesCol==null){
					_PortletDefinesCol=getPortletDefines();
				}
				return _PortletDefinesCol.iterator();
			}else{
				for (Iterator iter = _EditPortletItem.getPortletParamKeys(); iter.hasNext();) {
					String keyEntry = (String) iter.next();

					Map map=new HashMap();
					String label=null;
					PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
					PortletDefine defineItem=portletManager.getPortletDefine(_EditPortletItem.getPortletName());
					if(defineItem!=null){
						PortletParam portletParam=defineItem.getPortletParam(keyEntry);
						if(portletParam!=null){
							label=portletParam.getParam("label");
						}
					}
					if(label!=null){
						map.put("label",label);
					}else{
						map.put("label",keyEntry);
					}
					map.put("name",keyEntry);
					map.put("value",_EditPortletItem.getPortletParam(keyEntry));
					col.add(map);
				}
			}
		}
		return col;
	}
	private PortletItem getLeafItem(Collection leafs,String id){
		for (Iterator iter = leafs.iterator(); iter.hasNext();) {
			PortletItem leaf = (PortletItem) iter.next();
			if(leaf.getId()!=null&&leaf.getId().equals(id)){
				return leaf;
			}
		}
		return null;
	}


	private Collection getPortletDefines(){
		PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
		SecurityManager securityManager=(SecurityManager)ContextManager.lookupImplementer("com.ponpo.portal.SecurityManager");
		Map topMap=new TreeMap();
		
		for (Iterator iter = portletManager.getPortletDefinesKeys(); iter.hasNext();) {
			String keyEntry = (String) iter.next();
			PortletDefine portletDefine=portletManager.getPortletDefine(keyEntry);
			if(securityManager.isEnabled(_ServletRequest,_ServletResponse,portletDefine.getRole())){
				String hidden=portletDefine.getMetaParam("hidden");
				if(hidden==null||!hidden.equals("true")){
					String keyword=portletDefine.getMetaParam("keyword");
					if(keyword==null){
						keyword="`";
					}

					Collection col=(Collection)topMap.get(keyword);
					if(col==null){
						col=new TreeSet(new MapComparator());						
						topMap.put(keyword,col);
					}
					Map map=new HashMap();
					map.put("keyword",portletDefine.getMetaParam("keyword"));
					map.put("description",portletDefine.getMetaParam("description"));
					map.put("name",portletDefine.getPortletName());
					map.put("pid",portletDefine.getPortletId());
					if(portletDefine.getPortletId().equals(_RequestDat.get("portletName"))){
						map.put("checked","checked");
						_RequestDat.put("dspPortletName",portletDefine.getPortletName());
					}
					col.add(map);
				}
			}
		}
		Collection rtnCol=new ArrayList();
		int pos=0;
		for (Iterator iter = topMap.keySet().iterator(); iter.hasNext();) {
			String keyword = (String) iter.next();
			Collection col=(Collection)topMap.get(keyword);
			Map map=new HashMap();
			rtnCol.add(map);
			map.put("details",col.iterator());
			map.put("keyword",keyword);
			map.put("id",String.valueOf(pos));
			pos++;
		}
		return rtnCol;
	}
	private void save(HttpServletRequest req) throws PortalException{
		PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
		UserManager userManager=(UserManager)ContextManager.lookupImplementer("com.ponpo.portal.UserManager");
		portletManager.savePortal(userManager.getStartPortal(req.getRemoteUser()));
	}
	/* ( Javadoc)
	 * @see com.ponpo.taglib.SelectData#getSelectValue(javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public String getSelectValue(HttpServletRequest req, String key) throws JspException {
		return (String)_RequestDat.get(key);
	}
	/* ( Javadoc)
	 * @see com.ponpo.taglib.SelectData#getOptions(javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public OptionData[] getOptions(HttpServletRequest req, String key) throws JspException {
		Collection col=new ArrayList();
		try{
			col.add(new OptionDataImpl("wȂ",""));
			if(req.getRemoteUser()!=null){
				col.add(new OptionDataImpl("vCx[g","##"+req.getRemoteUser()));
			}

			UserManager userManager=(UserManager)ContextManager.lookupImplementer("com.ponpo.portal.UserManager");
			for (Iterator iter = userManager.getRoles(); iter.hasNext();) {
				String role = (String) iter.next();

				col.add(new OptionDataImpl(role,role));
			}
			
			return (OptionDataImpl[])col.toArray(new OptionDataImpl[0]);
		}catch(PortalException e){
			throw new JspException(e.getCause());
		}
	}
	private String typeText(String value){
		StringBuffer sb=new  StringBuffer();
		sb.append("<input type=\"text\" name=\"value\" size=\"30\" value=\"");
		sb.append(Filter.doFilter(value));
		sb.append("\">");
		return sb.toString();
	}
	private String typeRadio(HttpServletRequest req,String name,String value,String other){

		OptionData optionDatas[];
		try {
			optionDatas = getOptionDatas(req,name,other);
		} catch (PortalException e) {
			return e.getCause().getMessage();
		} catch (Exception e) {
			return e.getMessage();
		}

		StringBuffer out = new StringBuffer();

		if (optionDatas != null) {
			for (int cnt = 0; cnt < optionDatas.length; cnt++) {
				OptionData option = optionDatas[cnt];
				out.append("<input type=\"radio\"");
				if (value != null && value.equals(option.getValue())) {
					out.append(" checked");
				}
				out.append(" name=\"value\" ");
				out.append("\" value=\"");
				out.append(Filter.doFilter(option.getValue()));
				out.append("\">");
				out.append(Filter.doFilter(option.getLavel()));
			}
		}
		return out.toString();
	}
	private String typeSelect(HttpServletRequest req,String name,String value,String other){

		OptionData optionDatas[];
		try {
			optionDatas = getOptionDatas(req,name,other);
		} catch (PortalException e) {
			return e.getCause().getMessage();
		} catch (Exception e) {
			return e.getMessage();
		}

		StringBuffer out = new StringBuffer();

		out.append("<select size=\"5\" name=\"value\">");
		if (optionDatas != null) {
			for (int cnt = 0; cnt < optionDatas.length; cnt++) {
				OptionData option = optionDatas[cnt];
				out.append("<option ");
				if (value != null && value.equals(option.getValue())) {
					out.append("selected ");
				}
				out.append("value=\"");
				out.append(Filter.doFilter(option.getValue()));
				out.append("\">");
				out.append(Filter.doFilter(option.getLavel()));
				out.append("</option>\n");
			}
		}
		out.append("</select>");
		return out.toString();

	}
	private OptionData[] getOptionDatas(HttpServletRequest req,String name,String other) throws Exception{

		OptionData optionDatas[];
		if(other.indexOf(",")==-1){
			Object object = Class.forName(other).newInstance();
			if(object instanceof PortletEditOption){
				optionDatas =((PortletEditOption)object).getOptions(req,name);
			}else{
				throw new Exception(other+""+PortletEditOption.class.getName()+"CvgĂ܂");
			}
		}else{
			optionDatas = OptionData4Const.getOptionsTwoValue(other);
		}
		return optionDatas;
	}


	private String typeCheck(String value,String other){
		StringBuffer sb=new  StringBuffer();
		sb.append("<input type=\"checkbox\" name=\"value\" value=\"");
		sb.append(Filter.doFilter(other));
		if(value!=null && value.equals(other)){
			sb.append("\" checked>");
		}else{
			sb.append("\">");
		}

		return sb.toString();
	}
	private String typeOther(HttpServletRequest req,String name,String value,String other){

		try {
			if(other==null){
				StringBuffer sb=new  StringBuffer();
				sb.append("<input type=\"hidden\" name=\"value\" value=\"");
				sb.append(Filter.doFilter(value));
				sb.append("\">");
				return sb.toString();
			}
			Object object = Class.forName(other).newInstance();
			if(object instanceof PortletEditText){
				return ((PortletEditText)object).getText(req,name,value);
			}else{
				return (other+""+PortletEditOption.class.getName()+"CvgĂ܂");
			}
		} catch (PortalException e) {
			return e.getCause().getMessage();
		} catch (Exception e) {
			return e.getMessage();
		}
	}
}
