/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.service.portlet.entry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

import com.ponpo.portal.ActionInfo;
import com.ponpo.portal.ContextManager;
import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortletAction;
import com.ponpo.portal.PortletDefine;
import com.ponpo.portal.PortletItem;
import com.ponpo.portal.PortletManager;
import com.ponpo.portal.PortletParam;
import com.ponpo.portal.PortletStyle;
import com.ponpo.portal.PortletSystemDataUtils;
import com.ponpo.portal.UserManager;
import com.ponpo.portal.action.EventPortletAction;
import com.ponpo.portal.util.MapComparator;
import com.ponpo.portal.util.RequestUtils;
import com.ponpo.portal.util.Validator;
import com.ponpo.taglib.IterateData;
import com.ponpo.taglib.OptionData;
import com.ponpo.taglib.OptionDataImpl;
import com.ponpo.taglib.PlainData;
import com.ponpo.taglib.SelectData;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class PortletEntry extends EventPortletAction implements  PortletAction,PlainData,IterateData,SelectData{

	private Map _RequestDat=new HashMap();

	/**
	 * \f[^쐬iʏjB<BR>
	 * <PRE>
	 * \f[^쐬܂iʏjB<BR>
	 * </PRE>
	 * @param req@NGXg
	 * @param res@X|X
	 * @param entry@Ă΂ꂽ|[g[g
	 * @throws PortalException@̑O
	 */
	public void displayInitDefault(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {


		Enumeration enum=req.getParameterNames() ;

		while (enum.hasMoreElements()) {
			String key = (String) enum.nextElement() ;
			String value=req.getParameter(key);
			if(value!=null && value.length()>0){
				_RequestDat.put(key,value);
			}
		}

		String actionName = RequestUtils.getActionName(req);
		if (actionName == null) {
			actionName = "add";
		}
		_RequestDat.put("entryAction", actionName);
		_RequestDat.put("myURL", PortletSystemDataUtils.getURL(entry));

	}
	public void displayExecDefault(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		displayInitDefault(req,res,entry);

	}
	/**
	 * \f[^쐬iXVjB<BR>
	 * <PRE>
	 * \f[^쐬܂iXVjB<BR>
	 * </PRE>
	 * @param req@NGXg
	 * @param res@X|X
	 * @param entry@Ă΂ꂽ|[g[g
	 * @throws PortalException@̑O
	 */
	public void displayInitUpd(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		displayInitDefault(req,res,entry);

		try {
			PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
			PortletDefine item=(PortletDefine)portletManager.getPortletDefine((String)_RequestDat.get("id"));
			_RequestDat.put("keyword",item.getMetaParam("keyword"));
			_RequestDat.put("description",item.getMetaParam("description"));
			_RequestDat.put("hidden",item.getMetaParam("hidden"));
			_RequestDat.put("name",item.getPortletName());
			_RequestDat.put("role",item.getRole());
			_RequestDat.put("newId",item.getPortletId());
			_RequestDat.put("id",item.getPortletId());
			PortletParam portletParam=item.getPortletParam("style");
			if(portletParam!=null){
				_RequestDat.put("style",portletParam.getValue());
			}
		} catch (Exception e) {
			throw new PortalException(e);
		}
	}
	public void displayInitDel(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		displayInitUpd(req,res,entry);
	}
	public void displayInitCopy(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		displayInitUpd(req,res,entry);
		_RequestDat.put("newId","");

	}
	/**
	 * ǉs̓̓`FbNB<BR>
	 * <PRE>
	 * ǉs̓̓`FbNs܂B<BR>
	 * </PRE>
	 * @param req@NGXg
	 * @param res@X|X
	 * @param entry@Ă΂ꂽ|[g[g
	 * @throws PortalException@̑O
	 */
	public void validateDefault(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException{

		String value;

		value=(String)_RequestDat.get("newId");
		if(Validator.checkEmpty(value)){
			_ValidateError.setMsg("hc͕K{ł");	
		}else{
			if(Validator.checkNotAlphanumericPlus(value,"_-")){
				_ValidateError.setMsg("hc͉pł");	
			}
			if(!RequestUtils.isActName(req,"upd")){
				PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
				PortletDefine item=portletManager.getPortletDefine((String)_RequestDat.get("newId"));
				if(item!=null){
					_ValidateError.setMsg("hc͑ŎgpĂ܂B");	
				}
			}
		}		
		value=(String)_RequestDat.get("name");
		if(Validator.checkEmpty(value)){
			_ValidateError.setMsg("|[g[g͕K{ł");	
		}		
	}
	public void validateDel(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException{
	}
	/* ( Javadoc)
	 * @see com.ponpo.portal.PortletAction#logic(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	public void logicAdd(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		try {
			PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
			PortletDefine item=portletManager.newPortletDefine((String)_RequestDat.get("newId"));
			item.addMetaParam("keyword",(String)_RequestDat.get("keyword"));
			item.addMetaParam("description",(String)_RequestDat.get("description"));
			item.addMetaParam("hidden",(String)_RequestDat.get("hidden"));
			item.setPortletName((String)_RequestDat.get("name"));
			item.setRole((String)_RequestDat.get("role"));
			if(_RequestDat.get("style")!=null){
				PortletParam portletParam=item.newPortletParam();
				portletParam.setName("style");
				portletParam.setValue((String)_RequestDat.get("style"));
				item.addPortletParam(portletParam);
			}

			portletManager.setPortletDefine(item);

			save();
		} catch (Exception e) {
			throw new PortalException(e);
		}
	}

	/* ( Javadoc)
	 * @see com.ponpo.portal.PortletAction#logic(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	public void logicDel(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {

		PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
		PortletDefine portletDefine=portletManager.getPortletDefine((String)_RequestDat.get("newId"));
		portletManager.removePortletDefine(portletDefine);
		save();

	}
	public void logicUpd(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		try {
			PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
			PortletDefine item=portletManager.getPortletDefine((String)_RequestDat.get("newId"));
			item.addMetaParam("keyword",(String)_RequestDat.get("keyword"));
			item.addMetaParam("description",(String)_RequestDat.get("description"));
			item.addMetaParam("hidden",(String)_RequestDat.get("hidden"));
			item.setPortletName((String)_RequestDat.get("name"));
			item.setRole((String)_RequestDat.get("role"));
			if(true)new RuntimeException("not TODO");
			if(_RequestDat.get("style")!=null){
				PortletParam portletParam=item.newPortletParam();
				portletParam.setName("style");
				portletParam.setValue((String)_RequestDat.get("style"));
				item.addPortletParam(portletParam);
			}else{
				PortletParam portletParam=item.getPortletParam("style");
				if(portletParam!=null){
					item.removePortletParam(portletParam);
				}
			}

		} catch (Exception e) {
			throw new PortalException(e);
		}
		save();
	}
	public void logicCopy(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		try {
			PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
			PortletDefine targetItem=portletManager.newPortletDefine((String)_RequestDat.get("newId"));
			targetItem.addMetaParam("keyword",(String)_RequestDat.get("keyword"));
			targetItem.addMetaParam("description",(String)_RequestDat.get("description"));
			targetItem.addMetaParam("hidden",(String)_RequestDat.get("hidden"));
			targetItem.setPortletName((String)_RequestDat.get("name"));
			targetItem.setRole((String)_RequestDat.get("role"));

			PortletDefine sourceItem=portletManager.getPortletDefine((String)_RequestDat.get("id"));
			for (Iterator iter = sourceItem.getPortletParamKeys(); iter.hasNext();) {
				String key = (String) iter.next();
				PortletParam sourcePortletParam=sourceItem.getPortletParam(key);
				targetItem.addPortletParam(sourcePortletParam.cloneItem());
			}
			for (Iterator iter = sourceItem.getActionKeys(); iter.hasNext();) {
				String key = (String) iter.next();
				ActionInfo sourceActionInfo=sourceItem.getAction(key);
				targetItem.addAction(sourceActionInfo.cloneItem());
			}

			if(_RequestDat.get("style")!=null){
				PortletParam portletParam=targetItem.newPortletParam();
				portletParam.setName("style");
				portletParam.setValue((String)_RequestDat.get("style"));
				targetItem.addPortletParam(portletParam);
			}

			portletManager.setPortletDefine(targetItem);

			save();
		} catch (Exception e) {
			throw new PortalException(e);
		}
	}




	/* ( Javadoc)
	 * @see com.ponpo.taglib.PlainData#getTagData(java.lang.String)
	 */
	public String getTagData(HttpServletRequest req,String key) throws JspException {
		return (String)_RequestDat.get(key);
	}

	Collection _PortletDefines;
	/* ( Javadoc)
	 * @see com.ponpo.taglib.IterateData#getIterator(java.lang.String)
	 */
	public Object getIterator(HttpServletRequest req,String key) throws JspException {
		if(_PortletDefines==null){
			_PortletDefines=getPortletDefines();
		}
		return getPortletDefines();
	}

	/* ( Javadoc)
	 * @see com.ponpo.taglib.SelectData#getOptions(java.lang.String)
	 */
	public OptionData[] getOptions(HttpServletRequest req,String key) throws JspException {
		Collection col=new ArrayList();
		try{
			col.add(new OptionDataImpl("wȂ",""));
			if(key.equals("role" )){
				UserManager userManager=(UserManager)ContextManager.lookupImplementer("com.ponpo.portal.UserManager");

				for (Iterator iter = userManager.getRoles(); iter.hasNext();) {
					String role = (String) iter.next();

					col.add(new OptionDataImpl(role,role));
				}
			}else{
				PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");

				for (Iterator iter = portletManager.getPortletStyleKeys(); iter.hasNext();) {
					String styleKey = (String) iter.next();
					PortletStyle portletStyle=portletManager.getPortletStyle(styleKey);
					col.add(new OptionDataImpl(portletStyle.getSytleName(),portletStyle.getSytleId()));
				}
			}
			
			return (OptionDataImpl[])col.toArray(new OptionDataImpl[0]);
		}catch(PortalException e){
			throw new JspException(e.getCause());
		}

	}
	private void save() throws PortalException{
		PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
		portletManager.savePortletDefine();
	}
	/* ( Javadoc)
	 * @see com.ponpo.taglib.SelectData#getSelectValue(javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public String getSelectValue(HttpServletRequest req, String key) throws JspException {
		return (String)_RequestDat.get(key);
	}
	private Collection getPortletDefines(){
		PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
		Map topMap=new TreeMap();
		
		for (Iterator iter = portletManager.getPortletDefinesKeys(); iter.hasNext();) {
			String keyEntry = (String) iter.next();
			PortletDefine portletDefine=portletManager.getPortletDefine(keyEntry);
			String keyword=portletDefine.getMetaParam("keyword");
			if(keyword==null){
				keyword="`";
			}
			Collection col=(Collection)topMap.get(keyword);
			if(col==null){
				col=new TreeSet(new MapComparator());
				
				topMap.put(keyword,col);
			}
			Map map=new HashMap();
			for (Iterator metaIter = portletDefine.getMetaParamKeys(); metaIter.hasNext();) {
				String metaKey = (String) metaIter.next();
				map.put(metaKey,portletDefine.getMetaParam(metaKey));
			}
			map.put("id",portletDefine.getPortletId());
			map.put("name",portletDefine.getPortletName());
			map.put("role",portletDefine.getRole());
			col.add(map);
		}
		Collection rtnCol=new ArrayList();
		int pos=0;
		for (Iterator iter = topMap.keySet().iterator(); iter.hasNext();) {
			String keyword = (String) iter.next();
			Collection col=(Collection)topMap.get(keyword);
			Map map=new HashMap();
			rtnCol.add(map);
			map.put("details",col.iterator());
			map.put("keyword",keyword);
			map.put("id",String.valueOf(pos));
			pos++;
		}
		return rtnCol;

	}
}
