/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.service.portlet.entry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;

import com.ponpo.portal.ActionInfo;
import com.ponpo.portal.ContextManager;
import com.ponpo.portal.ForceForward;
import com.ponpo.portal.ForwardingURL;
import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortletAction;
import com.ponpo.portal.PortletDefine;
import com.ponpo.portal.PortletItem;
import com.ponpo.portal.PortletManager;
import com.ponpo.portal.PortletParam;
import com.ponpo.portal.PortletSystemDataUtils;
import com.ponpo.portal.action.EventPortletAction;
import com.ponpo.portal.util.RequestUtils;
import com.ponpo.portal.util.Validator;
import com.ponpo.taglib.ComparatorByOption;
import com.ponpo.taglib.IterateData;
import com.ponpo.taglib.OptionData;
import com.ponpo.taglib.OptionDataImpl;
import com.ponpo.taglib.PlainData;
import com.ponpo.taglib.SelectData;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class PortletEntryDetail extends EventPortletAction implements  PortletAction,PlainData,IterateData,SelectData,ForwardingURL{

	private Map _RequestDat=new HashMap();
	private String KEY=PortletEntryDetail.class.getName()+"KEY";
	private PortletDefine _PortletDefine;
	private boolean _NoViewURL=false; 

	/**
	 * \f[^쐬iʏjB<BR>
	 * <PRE>
	 * \f[^쐬܂iʏjB<BR>
	 * </PRE>
	 * @param req@NGXg
	 * @param res@X|X
	 * @param entry@Ă΂ꂽ|[g[g
	 * @throws PortalException@̑O
	 */
	public void displayInitDefault(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {

		Enumeration enum=req.getParameterNames() ;

		while (enum.hasMoreElements()) {
			String key = (String) enum.nextElement() ;
			String value=req.getParameter(key);
			if(value!=null && value.length()>0){
				_RequestDat.put(key,value);
			}
		}
		String actionName = RequestUtils.getActionName(req);
		if (actionName == null) {
			actionName = "add";
		}
		_RequestDat.put("entryAction", actionName);

		if(_RequestDat.get("type")==null){
			_RequestDat.put("type","non");
		}

		_RequestDat.put("entryAction", actionName);
		_RequestDat.put("myURL",PortletSystemDataUtils.getURL(entry));

		setPortletDefineItemImpl(req);


	}
	public void displayInitUpd(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		displayInitDefault(req,res,entry);
		_RequestDat.put("label",_RequestDat.get("name"));
		if(_PortletDefine!=null){
			if(_RequestDat.get("type").equals("actionDefine")){
				ActionInfo actionInfo=(ActionInfo)_PortletDefine.getAction((String)_RequestDat.get("name"));
				_RequestDat.put("value",actionInfo.getPortletActionName());
			}else	if(_RequestDat.get("type").equals("actionParam")){
				ActionInfo actionInfo=(ActionInfo)_PortletDefine.getAction((String)_RequestDat.get("parentID"));
				_RequestDat.put("value",actionInfo.getParam((String)_RequestDat.get("name")));
			}else	if(_RequestDat.get("type").equals("dataDefParam")){
				PortletParam portletParam=_PortletDefine.getPortletParam((String)_RequestDat.get("parentID"));
				_RequestDat.put("value",portletParam.getParam((String)_RequestDat.get("name")));
				_RequestDat.put("label",getLabel((String)_RequestDat.get("name")));
			}else{
				PortletParam portletParam=_PortletDefine.getPortletParam((String)_RequestDat.get("name"));
				_RequestDat.put("value",portletParam.getValue());
			}
		}
	}
	public void displayInitDel(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {
		displayInitUpd(req,res,entry);
	}
	public void displayExecDefault(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException {

		displayInitDefault(req,res,entry);

	}
	private void setPortletDefineItemImpl(HttpServletRequest req){
		Map map=req.getParameterMap();
		HttpSession session=req.getSession(true);
		if (map.containsKey("id")){
			PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
			_PortletDefine=portletManager.getPortletDefine((String)_RequestDat.get("id"));
			session.setAttribute(KEY,_PortletDefine);			
		}else{
			_PortletDefine=(PortletDefine)session.getAttribute(KEY);			
		}
		if(_PortletDefine==null){
			_NoViewURL=true;
			throw new ForceForward((String)_RequestDat.get("myURL"),"Session Time Over");
		}else{
			_RequestDat.put("myName",_PortletDefine.getPortletName());
			_RequestDat.put("myPortrtId",_PortletDefine.getPortletId());
		}
	}
	/**
	 * ǉs̓̓`FbNB<BR>
	 * <PRE>
	 * ǉs̓̓`FbNs܂B<BR>
	 * </PRE>
	 * @param req@NGXg
	 * @param res@X|X
	 * @param entry@Ă΂ꂽ|[g[g
	 * @throws PortalException@̑O
	 */
	public void validateAdd(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException{

		String value;

		if(!_RequestDat.get("type").equals("actionDefine")){
			value=(String)_RequestDat.get("name");
			if(Validator.checkEmpty(value)){
					_ValidateError.setMsg("O͕K{͂łB");	
			}
		}else{
			value=(String)_RequestDat.get("value");
			if(Validator.checkEmpty(value)){
					_ValidateError.setMsg("ANV͕K{͂łB");	
			}
		}
	}
	public void validateUpd(HttpServletRequest req,HttpServletResponse res,PortletItem entry) throws PortalException{
		validateAdd(req,res,entry);
	}
	/* ( Javadoc)
	 * @see com.ponpo.portal.PortletAction#logic(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	public void logicAdd(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		try {
			if(_RequestDat.get("type").equals("actionDefine")){
				ActionInfo actionInfo;
				actionInfo=_PortletDefine.newAction((String)_RequestDat.get("by"));
				actionInfo.setName((String)_RequestDat.get("name"));
				actionInfo.setActionClass((String)_RequestDat.get("value"));
				_PortletDefine.addAction(actionInfo);
			}else	if(_RequestDat.get("type").equals("actionParam")){
				ActionInfo actionInfo=(ActionInfo)_PortletDefine.getAction((String)_RequestDat.get("parentID"));
				actionInfo.addParam((String)_RequestDat.get("name"),(String)_RequestDat.get("value"));
			}else{
				PortletParam portletParam=_PortletDefine.newPortletParam();
				portletParam.setName((String)_RequestDat.get("name"));
				portletParam.setValue((String)_RequestDat.get("value"));
				_PortletDefine.addPortletParam(portletParam);
			}
			save();
		} catch (Exception e) {
			throw new PortalException(e);
		}
	}

	/* ( Javadoc)
	 * @see com.ponpo.portal.PortletAction#logic(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	public void logicDel(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		try {
			if(_RequestDat.get("type").equals("actionDefine")){
				ActionInfo actionInfo=(ActionInfo)_PortletDefine.getAction((String)_RequestDat.get("name"));
				_PortletDefine.removeAction(actionInfo);
			}else	if(_RequestDat.get("type").equals("actionParam")){
				ActionInfo actionInfo=_PortletDefine.getAction((String)_RequestDat.get("parentID"));
				actionInfo.removeParam((String)_RequestDat.get("name"));
			}else	if(_RequestDat.get("type").equals("dataDefParam")){
				PortletParam portletParam=_PortletDefine.getPortletParam((String)_RequestDat.get("parentID"));
				portletParam.removeParam((String)_RequestDat.get("name"));
			}else{
				PortletParam portletParam=_PortletDefine.getPortletParam((String)_RequestDat.get("name"));
				_PortletDefine.removePortletParam(portletParam);
			}
			save();
		} catch (Exception e) {
			throw new PortalException(e);
		}

	}
	public void logicUpd(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		try {
			if(_RequestDat.get("type").equals("actionDefine")){
				ActionInfo actionInfo=(ActionInfo)_PortletDefine.getAction((String)_RequestDat.get("name"));
				actionInfo.setActionClass((String)_RequestDat.get("value"));
				_PortletDefine.addAction(actionInfo);
			}else	if(_RequestDat.get("type").equals("actionParam")){
				ActionInfo actionInfo=_PortletDefine.getAction((String)_RequestDat.get("parentID"));
				actionInfo.addParam((String)_RequestDat.get("name"),(String)_RequestDat.get("value"));
			}else	if(_RequestDat.get("type").equals("dataDefParam")){
				PortletParam portletParam=_PortletDefine.getPortletParam((String)_RequestDat.get("parentID"));
				portletParam.addParam((String)_RequestDat.get("name"),(String)_RequestDat.get("value"));
			}else{
				PortletParam portletParam=_PortletDefine.getPortletParam((String)_RequestDat.get("name"));
				portletParam.setValue((String)_RequestDat.get("value"));
				_PortletDefine.addPortletParam(portletParam);
			}
			save();
		} catch (Exception e) {
			throw new PortalException(e);
		}
	}

	/* ( Javadoc)
	 * @see com.ponpo.taglib.PlainData#getTagData(java.lang.String)
	 */
	public String getTagData(HttpServletRequest req,String key) throws JspException {
		return (String)_RequestDat.get(key);
	}

	/* ( Javadoc)
	 * @see com.ponpo.taglib.IterateData#getIterator(java.lang.String)
	 */
	public Object getIterator(HttpServletRequest req,String key) throws JspException {
		
		Collection col=new ArrayList();
		Map map;
		if(key.equals("portletParam")){
			for (Iterator iter = _PortletDefine.getPortletParamKeys(); iter.hasNext();) {
				String name = (String) iter.next();
				PortletParam portletParam=_PortletDefine.getPortletParam(name);
				String value = (String) portletParam.getValue();

				if(name.equals("style")){
					continue;
				}
				map=new HashMap();
				col.add(map);
				map.put("name",name);
				map.put("value",value);

				Collection subCol=new ArrayList();
				for (Iterator subIter = portletParam.getParamKeys(); subIter.hasNext();) {
					Map subMap=new HashMap();
					subCol.add(subMap);
					String paramName = (String) subIter.next();
					String paramValue = (String) portletParam.getParam(paramName);
					subMap.put("label",getLabel(paramName));
					subMap.put("name",paramName);
					subMap.put("value",paramValue);
				} 
				map.put("param",subCol.iterator());

			} 

		}else{
			if(_PortletDefine.getActionKeys().hasNext()){
				for (Iterator actionIter = _PortletDefine.getActionKeys(); actionIter.hasNext();) {

					String actionKey = (String) actionIter.next();
					ActionInfo actionInfo=_PortletDefine.getAction(actionKey);
					map=new HashMap();
					col.add(map);
					map.put("name",actionInfo.getName());
					map.put("actionClass",actionInfo.getPortletActionName());
					map.put("by",actionInfo.getType());

					Collection subCol=new ArrayList();
					for (Iterator iter = actionInfo.getParamKeys(); iter.hasNext();) {
						Map subMap=new HashMap();
						subCol.add(subMap);
						String name = (String) iter.next();
						String value = (String) actionInfo.getParam(name);
						subMap.put("name",name);
						subMap.put("value",value);
					} 
					map.put("isEmpty",subCol.isEmpty()?"true":"false");
					map.put("param",subCol.iterator());
				}
			}
		}
		return col;
	}

	/* ( Javadoc)
	 * @see com.ponpo.taglib.SelectData#getOptions(java.lang.String)
	 */
	public OptionData[] getOptions(HttpServletRequest req,String key) throws JspException {
		Collection col;
		if(_RequestDat.get("by")!=null){
			col=new TreeSet(new ComparatorByOption());
			PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
			for (Iterator iter = portletManager.getPortletDefinesKeys(); iter.hasNext();) {
				String keyEntry = (String) iter.next();
				PortletDefine portletDefine=portletManager.getPortletDefine(keyEntry);
				if(!portletDefine.getPortletId().equals(_PortletDefine.getPortletId())){
					col.add(new OptionDataImpl(portletDefine.getPortletName(),portletDefine.getPortletId()));
				}
			}
		}else{
			col=new ArrayList();
			col.add(new OptionDataImpl("eLXg","text"));
			col.add(new OptionDataImpl("WI","radio"));
			col.add(new OptionDataImpl("I","select"));
			col.add(new OptionDataImpl("`FbN","check"));
			col.add(new OptionDataImpl("̑","other"));
		}
		return (OptionDataImpl[])col.toArray(new OptionDataImpl[0]);

	}
	private void save() throws PortalException{
		PortletManager portletManager=(PortletManager)ContextManager.lookupImplementer("com.ponpo.portal.PortletManager");
		portletManager.savePortletDefine();
	}
	/* ( Javadoc)
	 * @see com.ponpo.taglib.SelectData#getSelectValue(javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public String getSelectValue(HttpServletRequest req, String key) throws JspException {
		return (String)_RequestDat.get(key);
	}
	/* ( Javadoc)
	 * @see com.ponpo.portal.ForwardingURL#getFrowardURLWhenExec(javax.servlet.http.HttpServletRequest)
	 */
	public String getFrowardURLWhenExec(HttpServletRequest req) {
		String myURL=(String)_RequestDat.get("myURL");
		if(_NoViewURL){
			return myURL;
		}
		return myURL+"/detail";
	}
	private String getLabel(String value){
		if(value.equals("discription")){
			return "͐";
		}else if(value.equals("inputType")){
			return "^Cv";
		}else if(value.equals("label")){
			return "o";
		}else{
			return "̑ ";
		}

	}
}
