/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.service.sample;

import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;

import com.ponpo.portal.PortalException;
import com.ponpo.portal.skin.PortletEditOption;
import com.ponpo.portal.skin.PortletEditText;
import com.ponpo.taglib.Filter;
import com.ponpo.taglib.OptionData;
import com.ponpo.taglib.OptionDataImpl;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class SamplePortletParamOption implements PortletEditOption,PortletEditText {

	/*
	 *  ( Javadoc)
	 * @see com.ponpo.portal.service.EditOption#getOptions(javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public OptionData[] getOptions(HttpServletRequest req, String key){
		/*
		 * ̃\bh̓WIAI悤łB
		 * EditOptionCvg΂悢ł
		 */
		Collection col=new ArrayList();
		col.add(new OptionDataImpl("","green"));
		col.add(new OptionDataImpl("F","yellow"));
		col.add(new OptionDataImpl("","red"));
		return (OptionDataImpl[])col.toArray(new OptionDataImpl[0]);
	}

	/* ( Javadoc)
	 * @see com.ponpo.portal.service.PortletEditText#getText(javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public String getText(HttpServletRequest req, String key,String value) throws PortalException {
		StringBuffer sb=new  StringBuffer();
		sb.append("<input type=\"text\" name=\"value\" size=\"30\" value=\"");
		sb.append(Filter.doFilter(value));
		sb.append("\">");
		return sb.toString();
	}
}
