/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.service.shedule;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortletItem;
import com.ponpo.portal.PortletSystemDataUtils;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public abstract class CalendarManagerBase implements CalendarManager{
	protected String URL_PARM="calDate";

	protected JpCalendar _JpCalendar;
	protected EventInfoManager _EventInfoManager;
	protected Calendar _BaseDate;
	protected String _Url;

	public void init(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		Date dd;
		if (req.getParameterMap().containsKey(URL_PARM)) {
			SimpleDateFormat format= new SimpleDateFormat("yyyyMMdd");
			try {
				dd= format.parse(req.getParameter(URL_PARM));
			} catch (ParseException e) {
				dd= new Date(System.currentTimeMillis());
			}
		} else {
			dd= new Date(System.currentTimeMillis());
		}
		_BaseDate= Calendar.getInstance();
		_BaseDate.setTime(dd);

		String groupId=entry.getStrParam("groupID");
		if(groupId==null||groupId.length()==0){
			groupId="guest";
		}

		_EventInfoManager= new EventInfoManager(groupId, DateUtils.gateDateString(_BaseDate));
		_JpCalendar= new JpCalendar(_BaseDate.get(Calendar.YEAR));
		_Url= PortletSystemDataUtils.getURL(entry);
		

	}
	public Calendar getBaseDate() {
		return _BaseDate;
	}
	public Collection createCalendar() throws PortalException {

		Collection weekData= null;
		Collection monthData= new ArrayList();

		Calendar cal= getStartData();
		Calendar endCal= getEndData();

		int week= cal.get(Calendar.DAY_OF_WEEK);
		int changeWeek= week;

		while (cal.before(endCal)) {
			if (cal.get(Calendar.DAY_OF_WEEK) == changeWeek) {
				weekData= new ArrayList();
				Map map= new HashMap();
				map.put("weekData", weekData);
				monthData.add(map);
			}
			Map dayMap= new HashMap();
			dayMap.put("classId", getDispClassId(cal));
			dayMap.put("dateData", getDispDateData(cal));

			weekData.add(dayMap);
			cal.add(Calendar.DATE, 1);
		}
		return monthData;
	}
	public String getPrevMonth() {
		StringBuffer sb= new StringBuffer();
		Calendar prevCal= Calendar.getInstance();
		prevCal.setTime(_BaseDate.getTime());
		prevCal.add(Calendar.MONTH, -1);
		sb.append(_Url);
		sb.append("?");
		sb.append(URL_PARM);
		sb.append("=");
		sb.append(DateUtils.gateDateString(prevCal));
		return sb.toString();
	}
	public String getNextMonth() {
		StringBuffer sb= new StringBuffer();
		sb.append(_Url);
		Calendar nextCal= Calendar.getInstance();
		nextCal.setTime(_BaseDate.getTime());
		nextCal.add(Calendar.MONTH, 1);
		sb.append(_Url);
		sb.append("?");
		sb.append(URL_PARM);
		sb.append("=");
		sb.append(DateUtils.gateDateString(nextCal));
		return sb.toString();
	}
	public String getDispClassId(Calendar calendar) {

		if (_BaseDate.get(Calendar.YEAR) == calendar.get(Calendar.YEAR)
			&& _BaseDate.get(Calendar.MONTH) == calendar.get(Calendar.MONTH)){
			if (_BaseDate.get(Calendar.DATE) == calendar.get(Calendar.DATE)) {
				return "activeDay";
			} else {
				boolean holyDay= isHolyDay(calendar);
				if (holyDay) {
					return "holyDay";
				} else {
					return "weekDay";
				}
			}
		}else{
			return "emptyDay";
		}
	}
	protected boolean isHolyDay(Calendar calendar) {
		int week= calendar.get(Calendar.DAY_OF_WEEK);
		if (week == Calendar.SUNDAY || week == Calendar.SATURDAY) {
			return true;
		}
		return _JpCalendar.isHolyday(calendar.get(Calendar.MONTH) + 1, calendar.get(Calendar.DATE));
	}
	protected Calendar getStartData() {
		Calendar cal= Calendar.getInstance();
		cal.set(_BaseDate.get(Calendar.YEAR), _BaseDate.get(Calendar.MONTH), 1);
		int week= cal.get(Calendar.DAY_OF_WEEK);
		cal.add(Calendar.DATE, -1 * week +1);
		return cal;
	}
	protected Calendar getEndData() {
		Calendar cal= Calendar.getInstance();
		cal.set(_BaseDate.get(Calendar.YEAR), _BaseDate.get(Calendar.MONTH) + 1, 0);
		int week= cal.get(Calendar.DAY_OF_WEEK);
		cal.add(Calendar.DATE, Calendar.SATURDAY - week+1);
		return cal;
	}
	protected String getDispDateData(Calendar calendar) throws PortalException {
		StringBuffer sb= new StringBuffer();
		sb.append("<a href=\"" + _Url +"?"+URL_PARM +"="+DateUtils.gateDateString(calendar)+"\">");
		sb.append(calendar.get(Calendar.DATE));
		sb.append("</a>");
		String holyDay=_JpCalendar.getHolidayName(calendar.get(Calendar.MONTH) + 1, calendar.get(Calendar.DATE));
		if(holyDay.length()>0){
			sb.append("<span class=\"holydayName\">");
			sb.append(holyDay);
			sb.append("</span>");
		}
		sb.append("<BR>");
		sb.append(getEvent(calendar));

		return sb.toString();
	}
	abstract protected String getEvent(Calendar cal);

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @return
	 */
	public EventInfoManager getEventInfoManager() {
		return _EventInfoManager;
	}

	/**
	 * B<BR>
	 * <PRE>
	 * </PRE>
	 * @param manager
	 */
	public void setEventInfoManager(EventInfoManager manager) {
		_EventInfoManager= manager;
	}

}
