/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.service.shedule;

import java.util.Calendar;
import java.util.Iterator;


/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class CalendarManagerEvent extends CalendarManagerBase implements CalendarManager{
	protected String getEvent(Calendar cal) {
		StringBuffer sb= new StringBuffer();
		for (Iterator iter= _EventInfoManager.getTask(DateUtils.gateDateString(cal)); iter.hasNext();) {
			EventInfo info= (EventInfo)iter.next();
			sb.append("<li class=\"event\">");
			if(info.getStartTime()!=null){
				sb.append(info.getStartTime());
			}
			if(info.getEndTime()!=null){
				sb.append("`");
				sb.append(info.getEndTime());
			}
			if(info.getStartTime()!=null||info.getEndTime()!=null){
				sb.append("<br>");
			}
			sb.append(info.getTital());
			sb.append("</li>\n");
		}
		return sb.toString();
	}
}
