/* ================================================
 * Joker for enterprise information portal
 * ================================================
 *
 * (C) Copyright 2004-2005, by IT PONPO Limited. info@ponpo.com
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
package com.ponpo.portal.service.shedule;

import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

import org.apache.commons.beanutils.BeanUtils;

import com.ponpo.portal.ForwardingURL;
import com.ponpo.portal.PortalException;
import com.ponpo.portal.PortletItem;
import com.ponpo.portal.PortletSystemDataUtils;
import com.ponpo.portal.action.EventPortletAction;
import com.ponpo.portal.util.ObjectComparator;
import com.ponpo.portal.util.RequestUtils;
import com.ponpo.portal.util.Validator;
import com.ponpo.taglib.IterateData;
import com.ponpo.taglib.PlainData;

/**
 * B<BR>
 * <PRE>
 * </PRE>
 * @since 1.0.0
 * @version 1.00.00
 */
public class EventEntry extends EventPortletAction implements PlainData, IterateData,ForwardingURL {
	private Map _RequestDat= new HashMap();
	private EventInfoManager _EventInfoManager;
	private Collection _EventData;
	private Collection _MonthData;
	private String _myUrl;

	/* ( Javadoc)
	 * @see com.ponpo.portal.PortletAction#setData(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.ponpo.portal.PortletItem)
	 */
	public void displayInitDefault(HttpServletRequest req, HttpServletResponse res, PortletItem entry)
		throws PortalException {
		Enumeration enum= req.getParameterNames();
		while (enum.hasMoreElements()) {
			String key= (String)enum.nextElement();
			String value= req.getParameter(key);
			if (value != null && value.length() > 0) {
				_RequestDat.put(key, value);
			}
		}
		String actionName= RequestUtils.getActionName(req);
		if (actionName == null) {
			actionName= "";
		}
		_RequestDat.put("entryAction", actionName);

		CalendarManager calendarManager=new CalendarManagerEvent();
		calendarManager.init(req,res,entry);

		 Calendar daseDate= calendarManager.getBaseDate();
		_EventInfoManager= calendarManager.getEventInfoManager();
		if(_RequestDat.get("calDate")==null){
			_RequestDat.put("calDate", DateUtils.gateDateString(daseDate));
		}

		_RequestDat.put("year", String.valueOf(daseDate.get(Calendar.YEAR)));
		_RequestDat.put("month", String.valueOf(daseDate.get(Calendar.MONTH) + 1));
		_RequestDat.put("prevMonth", calendarManager.getPrevMonth());
		_RequestDat.put("nextMonth", calendarManager.getNextMonth());

		_EventData= new TreeSet(new ObjectComparator("startTime"));
		for (Iterator iter= _EventInfoManager.getTask((String)_RequestDat.get("calDate")); iter.hasNext();) {
			_EventData.add(iter.next());
		}
		_RequestDat.put("hasEventData", String.valueOf(!_EventData.isEmpty()));

		_MonthData=calendarManager.createCalendar();
		_myUrl=PortletSystemDataUtils.getURL(entry);
	}
	public void displayExecDefault(HttpServletRequest req, HttpServletResponse res, PortletItem entry)
		throws PortalException {
		displayInitDefault(req, res, entry);
	}
	public void displayInitUpd(HttpServletRequest req, HttpServletResponse res, PortletItem entry)
		throws PortalException {
		displayInitDefault(req, res, entry);
		EventInfo eventInfo= _EventInfoManager.getEventInfo((String)_RequestDat.get("eventId"));
		try {
			_RequestDat.putAll(BeanUtils.describe(eventInfo));
		} catch (Exception e) {
			throw new PortalException(e);
		}
	}
	public void displayInitDel(HttpServletRequest req, HttpServletResponse res, PortletItem entry)
		throws PortalException {
		displayInitUpd(req, res, entry);
	}
	public void validateAdd(HttpServletRequest req, HttpServletResponse res, PortletItem entry)
		throws PortalException {
		String value;
		value= (String)_RequestDat.get("tital");
		if (Validator.checkEmpty(value)) {
			_ValidateError.setMsg("^Cg͕K{͂łB");
		}
	}
	public void validateUpd(HttpServletRequest req, HttpServletResponse res, PortletItem entry)
		throws PortalException {
		validateAdd(req, res, entry);
	}
	public void logicAdd(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		EventInfo eventInfo= new EventInfo();
		try {
			BeanUtils.populate(eventInfo, _RequestDat);
			_EventInfoManager.setEventInfo(eventInfo);
		} catch (IllegalAccessException e) {
			throw new PortalException(e);
		} catch (InvocationTargetException e) {
			throw new PortalException(e);
		}
		_RequestDat.put("entryAction", "");
	}
	public void logicUpd(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		EventInfo eventInfo= _EventInfoManager.getEventInfo((String)_RequestDat.get("eventId"));
		if (eventInfo == null) {
			return;
		}
		try {
			BeanUtils.populate(eventInfo, _RequestDat);
			_EventInfoManager.setEventInfo(eventInfo);
		} catch (IllegalAccessException e) {
			throw new PortalException(e);
		} catch (InvocationTargetException e) {
			throw new PortalException(e);
		}
		_RequestDat.put("entryAction", "");
	}
	public void logicDel(HttpServletRequest req, HttpServletResponse res, PortletItem entry) throws PortalException {
		EventInfo eventInfo= _EventInfoManager.getEventInfo((String)_RequestDat.get("eventId"));
		if (eventInfo == null) {
			return;
		}
		_EventInfoManager.removeEventInfo(eventInfo);
		_RequestDat.put("entryAction", "");
	}
	public void logicCancel(HttpServletRequest req, HttpServletResponse res, PortletItem entry)
		throws PortalException {
		_RequestDat.put("entryAction", "");
	}

	/* ( Javadoc)
	 * @see com.ponpo.taglib.PlainData#getTagData(java.lang.String)
	 */
	public String getTagData(HttpServletRequest req, String key) {
		return (String)_RequestDat.get(key);
	}

	/* ( Javadoc)
	 * @see com.ponpo.taglib.IterateData#getIterator(javax.servlet.http.HttpServletRequest, java.lang.String)
	 */
	public Object getIterator(HttpServletRequest req, String reqKey) throws JspException {
		if (reqKey.equals("monthData")) {
			return _MonthData;
		} else {
			return _EventData;
		}
	}
	/* ( Javadoc)
	 * @see com.ponpo.portal.ForwardingURL#getFrowardURLWhenExec(javax.servlet.http.HttpServletRequest)
	 */
	public String getFrowardURLWhenExec(HttpServletRequest req) {
		return _myUrl+"?calDate="+_RequestDat.get("calDate");
	}
}
